/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.Enumeration;

public class ERXUnitAwareDecimalFormat
extends DecimalFormat
implements Cloneable,
Serializable {
    public static final String BYTE = "byte";
    public static final String METER = "meter";
    public static final String GRAM = "gram";
    public static final String SECOND = "second";
    protected final NSArray unitPrefixArray;

    public ERXUnitAwareDecimalFormat() {
        this.unitPrefixArray = NSArray.EmptyArray;
    }

    public ERXUnitAwareDecimalFormat(String unitName) {
        this.unitPrefixArray = UnitPrefix.unitPrefixArrayForUnit(unitName);
    }

    public ERXUnitAwareDecimalFormat(NSArray unitPrefixArray) {
        this.unitPrefixArray = unitPrefixArray;
    }

    public ERXUnitAwareDecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        super(pattern, symbols);
        this.unitPrefixArray = NSArray.EmptyArray;
    }

    public ERXUnitAwareDecimalFormat(String pattern, DecimalFormatSymbols symbols, String unitName) {
        super(pattern, symbols);
        this.unitPrefixArray = UnitPrefix.unitPrefixArrayForUnit(unitName);
    }

    public ERXUnitAwareDecimalFormat(String pattern, DecimalFormatSymbols symbols, NSArray unitPrefixArray) {
        super(pattern, symbols);
        this.unitPrefixArray = unitPrefixArray;
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        StringBuffer result = toAppendTo;
        UnitPrefix unitPrefix = UnitPrefix.findAppropriatePrefix(number, this.unitPrefixArray);
        if (unitPrefix == null) {
            result = super.format(number, toAppendTo, fieldPosition);
        } else {
            double convertedNumber = unitPrefix.adjustScale(number);
            result = super.format(convertedNumber, toAppendTo, fieldPosition);
            result.append(" ").append(unitPrefix.unitSymbol());
        }
        return result;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.format((double)number, toAppendTo, fieldPosition);
    }

    public static class UnitPrefix
    implements NSKeyValueCoding {
        private static NSArray _bytePrefixArray;
        private static NSArray _meterPrefixArray;
        private static NSArray _gramPrefixArray;
        private static NSArray _secondPrefixArray;
        protected final String unitSymbol;
        protected final String unitName;
        protected final double multiplyingFactor;
        private String _toString;

        public UnitPrefix(String unitSymbol, String unitName, double multiplyingFactor) {
            this.unitSymbol = unitSymbol;
            this.unitName = unitName;
            this.multiplyingFactor = multiplyingFactor;
        }

        public String unitSymbol() {
            return this.unitSymbol;
        }

        public String unitName() {
            return this.unitName;
        }

        public double multiplyingFactor() {
            return this.multiplyingFactor;
        }

        public double adjustScale(double number) {
            return number / this.multiplyingFactor;
        }

        public double adjustScale(long number) {
            return this.adjustScale((double)number);
        }

        public static NSArray unitPrefixArrayForUnit(String unitName) {
            NSArray unitPrefixArray = NSArray.EmptyArray;
            if (ERXUnitAwareDecimalFormat.BYTE.equals(unitName)) {
                if (_bytePrefixArray == null) {
                    _bytePrefixArray = new NSArray<Object>(new Object[]{new UnitPrefix("bytes", ERXUnitAwareDecimalFormat.BYTE, 1.0), new UnitPrefix("KB", "kilobyte", 1024.0), new UnitPrefix("MB", "megabyte", 1048576.0), new UnitPrefix("GB", "gigabyte", 1.073741824E9), new UnitPrefix("TB", "terabyte", 1.099511627776E12)});
                }
                unitPrefixArray = _bytePrefixArray;
            } else if (ERXUnitAwareDecimalFormat.METER.equals(unitName)) {
                if (_meterPrefixArray == null) {
                    _meterPrefixArray = new NSArray<Object>(new Object[]{new UnitPrefix("nm", "nanometer", 9.999999999999999E-10), new UnitPrefix("micrometer", "micrometer", 1.0E-6), new UnitPrefix("mm", "millimeter", 0.001), new UnitPrefix("cm", "centimeter", 0.01), new UnitPrefix("m", ERXUnitAwareDecimalFormat.METER, 1.0), new UnitPrefix("km", "kilometer", 1000.0)});
                }
                unitPrefixArray = _meterPrefixArray;
            } else if (ERXUnitAwareDecimalFormat.GRAM.equals(unitName)) {
                if (_gramPrefixArray == null) {
                    _gramPrefixArray = new NSArray<Object>(new Object[]{new UnitPrefix("mg", "milligram", 0.001), new UnitPrefix("g", ERXUnitAwareDecimalFormat.GRAM, 1.0), new UnitPrefix("kg", "kilogram", 1000.0), new UnitPrefix("ton", "metric ton", 1000000.0), new UnitPrefix("kiloton", "metric kiloton", 1.0E9)});
                }
                unitPrefixArray = _gramPrefixArray;
            } else if (ERXUnitAwareDecimalFormat.SECOND.equals(unitName)) {
                if (_secondPrefixArray == null) {
                    _secondPrefixArray = new NSArray<Object>(new Object[]{new UnitPrefix("ps", "picosecond", 9.999999999999998E-13), new UnitPrefix("ns", "nanosecond", 9.999999999999999E-10), new UnitPrefix("microsecond", "microsecond", 1.0E-6), new UnitPrefix("ms", "millisecond", 0.001), new UnitPrefix("sec", ERXUnitAwareDecimalFormat.SECOND, 1.0), new UnitPrefix("min", "minute", 60.0), new UnitPrefix("hour", "hour", 3600.0), new UnitPrefix("day", "day", 86400.0)});
                }
                unitPrefixArray = _secondPrefixArray;
            }
            return unitPrefixArray;
        }

        public static UnitPrefix findAppropriatePrefix(double number, NSArray unitPrefixArray) {
            UnitPrefix unitPrefix = null;
            Enumeration e = unitPrefixArray.reverseObjectEnumerator();
            while (e.hasMoreElements() && !(number >= (unitPrefix = (UnitPrefix)e.nextElement()).multiplyingFactor())) {
            }
            return unitPrefix;
        }

        public Object valueForKey(String key) {
            return NSKeyValueCoding.DefaultImplementation.valueForKey((Object)this, (String)key);
        }

        public void takeValueForKey(Object value, String key) {
            throw new NSKeyValueCoding.UnknownKeyException("Can't take the value " + value + " for the key " + key + " since " + this.getClass().getName() + " is immutable.", value, key);
        }

        public String toString() {
            if (this._toString == null) {
                this._toString = "<" + this.getClass().getName() + " " + this.unitName + "(" + this.unitSymbol + ") [" + this.multiplyingFactor + "] >";
            }
            return this._toString;
        }
    }
}

