/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.qualifiers.ERXRegExQualifier;
import er.extensions.foundation.ERXProperties;
import er.extensions.localization.ERXLocalizer;
import java.text.Collator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ERXComparisonSupport {
    private static final Logger log = Logger.getLogger(ERXComparisonSupport.class);
    private static Class stringClass = String.class;
    private static final int MAGIC = -42;
    private static boolean fixAnyway;

    public static void initialize() {
        EOSortOrdering.ComparisonSupport.setSupportForClass((EOSortOrdering.ComparisonSupport)new StringSortSupport(), String.class);
        EOQualifier.ComparisonSupport.setSupportForClass((EOQualifier.ComparisonSupport)new StringQualifierSupport(), String.class);
        fixAnyway = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXComparisonSupport.fixAnyway", true);
    }

    protected static class StringSortSupport
    extends EOSortOrdering.ComparisonSupport {
        protected StringSortSupport() {
        }

        private Collator collator() {
            Locale locale = ERXLocalizer.currentLocalizer().locale();
            if (locale != null) {
                locale = Locale.getDefault();
            }
            return Collator.getInstance(locale);
        }

        private static int _handleNulls(Object object1, Object object2) {
            if (object1 == null || object1 == NSKeyValueCoding.NullValue) {
                if (object2 == null || object2 == NSKeyValueCoding.NullValue) {
                    return 0;
                }
                return -1;
            }
            if (object2 == null || object2 == NSKeyValueCoding.NullValue) {
                return 1;
            }
            return -42;
        }

        protected int _genericCompareTo(Object object1, Object object2) {
            if (fixAnyway) {
                int i = StringSortSupport._handleNulls(object1, object2);
                if (i != -42) {
                    return i;
                }
                Class<?> clazz = object1.getClass();
                if (clazz == stringClass) {
                    return this.collator().compare(object1.toString(), object2.toString());
                }
            }
            return super._genericCompareTo(object1, object2);
        }

        protected int _genericCaseInsensitiveCompareTo(Object object1, Object object2) {
            int i = StringSortSupport._handleNulls(object1, object2);
            if (i != -42) {
                return i;
            }
            Class<?> clazz = object1.getClass();
            if (clazz == stringClass) {
                return this.collator().compare(object1.toString().toUpperCase(), object2.toString().toUpperCase());
            }
            return super._genericCaseInsensitiveCompareTo(object1, object2);
        }
    }

    protected static class StringQualifierSupport
    extends EOQualifier.ComparisonSupport {
        protected StringQualifierSupport() {
        }

        public boolean _compareWithArbitrarySelector(Object aLeft, Object aRight, NSSelector aSelector) {
            if (aSelector.name().equals("matches")) {
                aSelector = ERXRegExQualifier.MatchesSelector;
            }
            return super._compareWithArbitrarySelector(aLeft, aRight, aSelector);
        }
    }
}

