/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXProperties;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXExpiringCache<K, V> {
    public static final long NO_TIMEOUT = 0L;
    public static final Object NO_VERSION = new Object();
    private static GrimReaper _reaper;
    private NSMutableDictionary<K, Entry<V>> _backingDictionary;
    private long _expiryTime;
    private long _cleanupPause;
    private long _lastCleanupTime;

    public ERXExpiringCache() {
        this(60L);
    }

    public ERXExpiringCache(long expiryTimeInSeconds) {
        this(expiryTimeInSeconds, expiryTimeInSeconds);
    }

    public ERXExpiringCache(long expiryTimeInSeconds, long cleanupPauseInSeconds) {
        this._expiryTime = expiryTimeInSeconds * 1000L;
        this._cleanupPause = cleanupPauseInSeconds * 1000L;
        if (this._cleanupPause == 0L) {
            this._cleanupPause = 60000L;
        }
        this._lastCleanupTime = 0L;
        this._backingDictionary = new NSMutableDictionary();
    }

    public synchronized void removeAllObjects() {
        for (Object key : this._backingDictionary.allKeys()) {
            this.removeEntryForKey(this.entryForKey(key), key);
        }
    }

    private long expiryTime() {
        return this._expiryTime;
    }

    public synchronized void setObjectForKey(V object, K key) {
        this.setObjectForKeyWithVersion(object, key, NO_VERSION);
    }

    public synchronized void setObjectForKeyWithVersion(V object, K key, Object currentVersionKey, long expirationTime) {
        this.removeStaleEntries();
        if (expirationTime != 0L) {
            expirationTime = System.currentTimeMillis() + expirationTime;
        }
        Entry<V> entry = new Entry<V>(object, expirationTime, currentVersionKey);
        this.setEntryForKey(entry, key);
    }

    public synchronized void setObjectForKeyWithVersion(V object, K key, Object currentVersionKey) {
        this.setObjectForKeyWithVersion(object, key, currentVersionKey, this._expiryTime);
    }

    public synchronized V objectForKey(K key) {
        return this.objectForKeyWithVersion(key, NO_VERSION);
    }

    public synchronized V objectForKeyWithVersion(K key, Object currentVersionKey) {
        Entry<V> entry = this.entryForKey(key);
        V value = null;
        if (entry != null) {
            if (entry.isStale(System.currentTimeMillis(), currentVersionKey)) {
                this.removeEntryForKey(entry, key);
            } else {
                value = entry.object();
            }
        }
        return value;
    }

    public synchronized boolean isStale(K key) {
        return this.isStaleWithVersion(key, NO_VERSION);
    }

    public synchronized boolean isStaleWithVersion(K key, Object currentVersionKey) {
        Entry<V> entry = this.entryForKey(key);
        boolean isStale = true;
        if (entry != null) {
            isStale = entry.isStale(System.currentTimeMillis(), currentVersionKey);
        }
        return isStale;
    }

    public synchronized V removeObjectForKey(K key) {
        this.removeStaleEntries();
        Entry<V> entry = this.entryForKey(key);
        V value = null;
        if (entry != null) {
            this.removeEntryForKey(entry, key);
            value = entry.object();
        }
        return value;
    }

    public synchronized void removeStaleEntries() {
        long now;
        if (this._backingDictionary.count() > 0 && this._lastCleanupTime + this._cleanupPause < (now = System.currentTimeMillis())) {
            this._lastCleanupTime = System.currentTimeMillis();
            Enumeration keyEnum = this._backingDictionary.keyEnumerator();
            while (keyEnum.hasMoreElements()) {
                Object key = keyEnum.nextElement();
                Entry<V> entry = this.entryForKey(key);
                if (!entry.isStale(now + 10000L, NO_VERSION)) continue;
                this.removeEntryForKey(entry, key);
            }
        }
    }

    protected synchronized void removeEntryForKey(Entry<V> entry, K key) {
        this._backingDictionary.removeObjectForKey(key);
    }

    protected synchronized void setEntryForKey(Entry<V> entry, K key) {
        this._backingDictionary.setObjectForKey(entry, key);
    }

    protected synchronized Entry<V> entryForKey(K key) {
        return (Entry)this._backingDictionary.objectForKey(key);
    }

    public String toString() {
        return super.toString() + " " + this._backingDictionary;
    }

    public void startBackgroundExpiration() {
        if (this._expiryTime == 0L) {
            throw new IllegalArgumentException("This ERXExpiringCache does not have an expiration time.");
        }
        ERXExpiringCache.reaper().addCache(this);
    }

    public synchronized void stopBackgroundExpiration() {
        ERXExpiringCache.reaper().stop(this);
    }

    protected static synchronized GrimReaper reaper() {
        if (_reaper == null) {
            _reaper = new GrimReaper(ERXProperties.intForKeyWithDefault("er.extensions.ERXExpiringCache.reaperFrequency", 5000));
        }
        return _reaper;
    }

    public synchronized NSArray<K> allKeys() {
        NSMutableArray<int> result = new NSMutableArray<int>(this._backingDictionary.count());
        for (Object key : this._backingDictionary.allKeys()) {
            result.addObject((int)key);
        }
        return result;
    }

    protected static class GrimReaper
    implements Runnable {
        private List<WeakReference<ERXExpiringCache>> _caches = new LinkedList<WeakReference<ERXExpiringCache>>();
        private long _reapFrequencyInMillis;
        private boolean _stopped;

        public GrimReaper(long reapFrequencyInMillis) {
            this._reapFrequencyInMillis = reapFrequencyInMillis;
            this._stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCache(ERXExpiringCache cache) {
            List<WeakReference<ERXExpiringCache>> list = this._caches;
            synchronized (list) {
                this._caches.add(new WeakReference<ERXExpiringCache>(cache));
                if (this._stopped) {
                    this.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            List<WeakReference<ERXExpiringCache>> list = this._caches;
            synchronized (list) {
                if (this._stopped) {
                    this._stopped = false;
                    Thread reaperThread = new Thread(this);
                    reaperThread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            List<WeakReference<ERXExpiringCache>> list = this._caches;
            synchronized (list) {
                this._stopped = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(ERXExpiringCache cache) {
            List<WeakReference<ERXExpiringCache>> list = this._caches;
            synchronized (list) {
                Iterator<WeakReference<ERXExpiringCache>> cacheIter = this._caches.iterator();
                while (cacheIter.hasNext()) {
                    WeakReference<ERXExpiringCache> cacheRef = cacheIter.next();
                    ERXExpiringCache reapingCache = (ERXExpiringCache)cacheRef.get();
                    if (reapingCache != cache) continue;
                    cacheIter.remove();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean stopped = false;
            do {
                try {
                    Thread.sleep(this._reapFrequencyInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<WeakReference<ERXExpiringCache>> list = this._caches;
                synchronized (list) {
                    Iterator<WeakReference<ERXExpiringCache>> cacheIter = this._caches.iterator();
                    while (cacheIter.hasNext()) {
                        WeakReference<ERXExpiringCache> cacheRef = cacheIter.next();
                        ERXExpiringCache cache = (ERXExpiringCache)cacheRef.get();
                        if (cache == null) {
                            cacheIter.remove();
                            continue;
                        }
                        cache.removeStaleEntries();
                    }
                    if (this._caches.size() == 0) {
                        this._stopped = true;
                        stopped = true;
                    }
                }
            } while (!stopped);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        private long _expiration;
        private Object _versionKey;
        private V _object;
        private boolean _stale;

        public Entry(V o, long expiration, Object version) {
            this._expiration = expiration;
            this._versionKey = version;
            this._object = o;
        }

        protected boolean isStale(long currentTime, Object currentVersionKey) {
            if (!this._stale) {
                this._stale = this._expiration != 0L && currentTime != 0L && this._expiration < currentTime ? true : (this._versionKey == NO_VERSION || currentVersionKey == NO_VERSION ? false : (this._object == null ? currentVersionKey != null : !this._versionKey.equals(currentVersionKey)));
            }
            return this._stale;
        }

        public V object() {
            return this._object;
        }

        public String toString() {
            return super.toString() + " { " + "expiration = " + (this._expiration == 0L ? "NO_TIMEOUT" : new Date(this._expiration)) + ", version = " + (this._versionKey == NO_VERSION ? "NO_VERSION" : this._versionKey) + ", object = " + this._object + " }";
        }
    }
}

