/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOSession;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSSet;
import er.extensions.appserver.ERXApplication;
import er.extensions.concurrency.ERXCloneableThreadLocal;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXValueUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXThreadStorage {
    private static final Logger log = Logger.getLogger(ERXThreadStorage.class);
    public static final String KEYS_ADDED_IN_CURRENT_THREAD_KEY = "ERXThreadStorage.keysAddedInCurrentThread";
    public static final String WAS_CLONED_MARKER = "ERXThreadStorage.wasCloned";
    private static Set<Class<?>> _problematicTypes;
    private static Set<String> _problematicKeys;
    private static ThreadLocal threadMap;
    private static Boolean _useInheritableThreadLocal;
    private static Boolean _logUsageOfProblematicInheritedValues;
    private static int DefaultHashMapSize;

    private static boolean useInheritableThreadLocal() {
        if (_useInheritableThreadLocal == null) {
            _useInheritableThreadLocal = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXThreadStorage.useInheritableThreadLocal", true);
        }
        return _useInheritableThreadLocal;
    }

    private static boolean logUsageOfProblematicInheritedValues() {
        if (_logUsageOfProblematicInheritedValues == null) {
            boolean devMode = ERXApplication.isDevelopmentModeSafe();
            _logUsageOfProblematicInheritedValues = ERXThreadStorage.useInheritableThreadLocal() && ERXProperties.booleanForKeyWithDefault("er.extensions.ERXThreadStorage.logUsageOfProblematicInheritedValues", devMode);
        }
        return _logUsageOfProblematicInheritedValues;
    }

    public static void takeValueForKey(Object object, String key) {
        Map map = ERXThreadStorage.storageMap(true);
        map.put(key, object);
        ERXThreadStorage.markKeyAddedInCurrentThread(key);
    }

    public static Object removeValueForKey(String key) {
        Map map = ERXThreadStorage.storageMap(false);
        return map != null ? map.remove(key) : null;
    }

    public static Object valueForKeyPath(String keyPath) {
        int dot = keyPath.indexOf(".");
        Object value = null;
        if (dot > 1) {
            value = ERXThreadStorage.valueForKey(keyPath.substring(0, dot));
            if (value != null) {
                value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)value, (String)keyPath.substring(dot + 1));
            }
        } else {
            value = ERXThreadStorage.valueForKey(keyPath);
        }
        return value;
    }

    public static Object valueForKey(String key) {
        Map map = ERXThreadStorage.storageMap(false);
        Object result = null;
        if (map != null) {
            result = map.get(key);
        }
        if (result != null && ERXThreadStorage.logUsageOfProblematicInheritedValues() && !ERXThreadStorage.wasKeyAddedInCurrentThread(key)) {
            for (Class<?> type : ERXThreadStorage.problematicTypes()) {
                if (!type.isAssignableFrom(result.getClass())) continue;
                String msg = "The object for key '" + key + "' was inherited from the parent thread. " + "The usage of inherited objects that are a subclass of '" + type.getSimpleName() + "' can cause problems.";
                log.warn((Object)msg, (Throwable)new Exception("DEBUG"));
            }
            if (ERXThreadStorage.problematicKeys().contains(key)) {
                String msg = "The object for key '" + key + "' was inherited from the parent thread. " + "The usage of inherited objects for this key can cause problems.";
                log.warn((Object)msg, (Throwable)new Exception("DEBUG"));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object valueForKey(EOEditingContext ec, String key) {
        Object result = ERXThreadStorage.valueForKey(key);
        if (result != null) {
            if (result instanceof EOEnterpriseObject) {
                EOEnterpriseObject eo = (EOEnterpriseObject)result;
                if (eo.editingContext() != null && eo.editingContext() != ec) {
                    eo.editingContext().lock();
                    try {
                        result = ERXEOControlUtilities.localInstanceOfObject(ec, eo);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        eo.editingContext().unlock();
                        throw throwable;
                    }
                    eo.editingContext().unlock();
                    {
                    }
                }
            } else {
                throw new ClassCastException("Expected EO, got : " + result.getClass().getName() + ", " + result);
            }
        }
        return result;
    }

    public static Map map() {
        return ERXThreadStorage.storageMap(true);
    }

    public static void reset() {
        Map map = ERXThreadStorage.storageMap(false);
        if (map != null) {
            map.clear();
        }
    }

    private static Map storageMap(boolean create) {
        HashMap map = (HashMap)threadMap.get();
        if (map == null && create) {
            map = new HashMap(DefaultHashMapSize);
            threadMap.set(map);
        }
        return map;
    }

    private static void markKeyAddedInCurrentThread(String key) {
        if (ERXThreadStorage.wasInheritedFromParentThread()) {
            Map map = ERXThreadStorage.storageMap(false);
            HashSet<String> blessedKeys = (HashSet<String>)map.get(KEYS_ADDED_IN_CURRENT_THREAD_KEY);
            if (blessedKeys == null) {
                blessedKeys = new HashSet<String>();
                map.put(KEYS_ADDED_IN_CURRENT_THREAD_KEY, blessedKeys);
            }
            blessedKeys.add(key);
        }
    }

    private static boolean wasKeyAddedInCurrentThread(String key) {
        if (!ERXThreadStorage.wasInheritedFromParentThread()) {
            return true;
        }
        Map map = ERXThreadStorage.storageMap(false);
        Set blessedKeys = (Set)map.get(KEYS_ADDED_IN_CURRENT_THREAD_KEY);
        return blessedKeys != null && blessedKeys.contains(key);
    }

    public static boolean wasInheritedFromParentThread() {
        Map map;
        boolean result = false;
        if (ERXThreadStorage.useInheritableThreadLocal() && (map = ERXThreadStorage.storageMap(false)) != null) {
            result = ERXValueUtilities.booleanValue(map.get(WAS_CLONED_MARKER));
        }
        return result;
    }

    public static void setProblematicTypes(NSSet<Class<?>> problematicTypes) {
        _problematicTypes = problematicTypes == null ? NSSet.EmptySet : problematicTypes;
    }

    public static Set<Class<?>> problematicTypes() {
        return _problematicTypes;
    }

    public static void setProblematicKeys(Set<String> problematicKeys) {
        _problematicKeys = problematicKeys == null ? NSSet.EmptySet : problematicKeys;
    }

    public static Set<String> problematicKeys() {
        return _problematicKeys;
    }

    static {
        threadMap = ERXThreadStorage.useInheritableThreadLocal() ? new ERXThreadStorageCloneableThreadLocal() : new ThreadLocal();
        _problematicTypes = new NSSet<Class>(new Class[]{WOSession.class, WOContext.class, EOEnterpriseObject.class, EOEditingContext.class});
        _problematicKeys = new NSSet<String>(new String[0]);
        DefaultHashMapSize = 10;
    }

    protected static class ERXThreadStorageCloneableThreadLocal
    extends ERXCloneableThreadLocal {
        protected ERXThreadStorageCloneableThreadLocal() {
        }

        protected Object childValue(Object parentValue) {
            Map map = (Map)super.childValue(parentValue);
            if (map != null) {
                map.put(ERXThreadStorage.WAS_CLONED_MARKER, Boolean.TRUE);
                map.remove(ERXThreadStorage.KEYS_ADDED_IN_CURRENT_THREAD_KEY);
            }
            return map;
        }
    }
}

