/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSTimestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class ERXTimestampUtilities {
    static NSTimestamp _epoch = new NSTimestamp(1970, 1, 1, 0, 0, 0, null);

    public static NSTimestamp timestampForString(String defaultValue) {
        NSTimestamp value = null;
        if (defaultValue.equals("now")) {
            value = new NSTimestamp();
        } else if (defaultValue.equals("today")) {
            value = ERXTimestampUtilities.today();
        } else if (defaultValue.equals("yesterday")) {
            value = ERXTimestampUtilities.yesterday();
        } else if (defaultValue.equals("tomorrow")) {
            value = ERXTimestampUtilities.tomorrow();
        } else if (defaultValue.equals("distantPast")) {
            value = ERXTimestampUtilities.distantPast();
        } else if (defaultValue.equals("distantFuture")) {
            value = ERXTimestampUtilities.distantFuture();
        }
        return value;
    }

    static ERXTimestamp getInstance() {
        return ERXTimestampUtilities.getInstance(new NSTimestamp());
    }

    static ERXTimestamp getInstance(NSTimestamp ts) {
        return new ERXTimestamp(ts);
    }

    public static NSTimestamp today() {
        ERXTimestamp now = ERXTimestampUtilities.getInstance();
        return now.ts.timestampByAddingGregorianUnits(0, 0, 0, -now.hourOfDay(), -now.minuteOfHour(), -now.secondOfMinute());
    }

    public static NSTimestamp tomorrow() {
        ERXTimestamp now = ERXTimestampUtilities.getInstance();
        return now.ts.timestampByAddingGregorianUnits(0, 0, 1, -now.hourOfDay(), -now.minuteOfHour(), -now.secondOfMinute());
    }

    public static NSTimestamp yesterday() {
        ERXTimestamp now = ERXTimestampUtilities.getInstance();
        return now.ts.timestampByAddingGregorianUnits(0, 0, -1, -now.hourOfDay(), -now.minuteOfHour(), -now.secondOfMinute());
    }

    public static NSTimestamp distantPast() {
        return NSTimestamp.DistantPast;
    }

    public static NSTimestamp distantFuture() {
        return NSTimestamp.DistantFuture;
    }

    public static NSTimestamp dateByAddingTime(NSTimestamp ts, NSTimestamp t1) {
        ERXTimestamp time = ERXTimestampUtilities.getInstance(t1);
        return ts.timestampByAddingGregorianUnits(0, 0, 0, time.hourOfDay(), time.minuteOfHour(), time.secondOfMinute());
    }

    public static NSTimestamp timestampByAddingTime(NSTimestamp ts, NSTimestamp t1) {
        ERXTimestamp time = ERXTimestampUtilities.getInstance(t1);
        return ts.timestampByAddingGregorianUnits(0, 0, 0, time.hourOfDay(), time.minuteOfHour(), time.secondOfMinute());
    }

    public static boolean isEarlierThan(NSTimestamp ts1, NSTimestamp ts2) {
        return ts1.compare(ts2) == -1;
    }

    public static boolean isLaterThan(NSTimestamp ts1, NSTimestamp ts2) {
        return ts1.compare(ts2) == 1;
    }

    public static NSTimestamp epoch() {
        return _epoch;
    }

    public static NSTimestamp unixDate(Number helpedNSNumber) {
        return ERXTimestampUtilities.epoch().timestampByAddingGregorianUnits(0, 0, 0, 0, 0, (int)helpedNSNumber.longValue() + 3600);
    }

    public static Integer unixTimestamp(NSTimestamp ts) {
        long seconds = 0L;
        seconds = ts.getTime() - ERXTimestampUtilities.epoch().getTime();
        return new Integer((int)((seconds - 3600L) / 1000L));
    }

    public static String simpleDateFormatForNSTimestampFormat(String timestampFormatterPattern) {
        StringBuffer dateFormat = new StringBuffer(timestampFormatterPattern.length());
        int length = timestampFormatterPattern.length();
        for (int i = 0; i < length; ++i) {
            char ch = timestampFormatterPattern.charAt(i);
            if (ch == '%') {
                char nextCh = timestampFormatterPattern.charAt(++i);
                switch (nextCh) {
                    case '%': {
                        dateFormat.append('%');
                        break;
                    }
                    case 'a': {
                        dateFormat.append("EEE");
                        break;
                    }
                    case 'A': {
                        dateFormat.append("EEEEE");
                        break;
                    }
                    case 'b': {
                        dateFormat.append("MMM");
                        break;
                    }
                    case 'B': {
                        dateFormat.append("MMMMM");
                        break;
                    }
                    case 'c': {
                        dateFormat.append(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3)).toPattern());
                        break;
                    }
                    case 'd': {
                        dateFormat.append("dd");
                        break;
                    }
                    case 'e': {
                        dateFormat.append("d");
                        break;
                    }
                    case 'F': {
                        dateFormat.append("SSS");
                        break;
                    }
                    case 'H': {
                        dateFormat.append("HH");
                        break;
                    }
                    case 'I': {
                        dateFormat.append("hh");
                        break;
                    }
                    case 'j': {
                        dateFormat.append("DDD");
                        break;
                    }
                    case 'm': {
                        dateFormat.append("MM");
                        break;
                    }
                    case 'M': {
                        dateFormat.append("mm");
                        break;
                    }
                    case 'p': {
                        dateFormat.append("aa");
                        break;
                    }
                    case 'S': {
                        dateFormat.append("ss");
                        break;
                    }
                    case 'w': {
                        dateFormat.append("EEE");
                        break;
                    }
                    case 'x': {
                        dateFormat.append(((SimpleDateFormat)SimpleDateFormat.getDateInstance(3)).toPattern());
                        break;
                    }
                    case 'X': {
                        dateFormat.append(((SimpleDateFormat)SimpleDateFormat.getTimeInstance(3)).toPattern());
                        break;
                    }
                    case 'y': {
                        dateFormat.append("yy");
                        break;
                    }
                    case 'Y': {
                        dateFormat.append("yyyy");
                        break;
                    }
                    case 'z': {
                        dateFormat.append("Z");
                        break;
                    }
                    case 'Z': {
                        dateFormat.append("z");
                        break;
                    }
                    default: {
                        dateFormat.append("%");
                        break;
                    }
                }
                continue;
            }
            dateFormat.append(ch);
        }
        return dateFormat.toString();
    }

    static class ERXTimestamp {
        private static final long _YEAR_1 = 1721426L;
        private GregorianCalendar _calendar;
        private NSTimestamp ts;

        ERXTimestamp(NSTimestamp value) {
            this.ts = value;
            this._calendar = new GregorianCalendar();
            this._calendar.setTime((Date)this.ts);
        }

        public long dayOfCommonEra() {
            int a = (14 - (this.monthOfYear() + 1)) / 12;
            int y = this.yearOfCommonEra() + 4800 - a;
            long m = this.monthOfYear() + 1 + 12 * a - 3;
            long julianDays = (long)this.dayOfMonth() + (153L * m + 2L) / 5L + (long)(365 * y) + (long)(y / 4) - (long)(y / 100) + (long)(y / 400) - 32045L;
            return julianDays - 1721426L;
        }

        public int dayOfWeek() {
            return this._calendar.get(7);
        }

        public int dayOfMonth() {
            return this._calendar.get(5);
        }

        public int dayOfYear() {
            return this._calendar.get(6);
        }

        public int hourOfDay() {
            return this._calendar.get(11);
        }

        public int minuteOfHour() {
            return this._calendar.get(12);
        }

        public int secondOfMinute() {
            return this._calendar.get(13);
        }

        public int monthOfYear() {
            return this._calendar.get(2);
        }

        public int yearOfCommonEra() {
            return this._calendar.get(1);
        }
    }
}

