/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.logging.ERXPatternLayout;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerRepository;

public class ERXLog4JConfiguration
extends WOComponent {
    private Logger _logger;
    private String _filterString;
    private String _ruleKey;
    private String _loggerName;
    public LoggerLevel filterLevel;
    public LoggerLevel newLoggerLevel = null;
    private NSArray _appenders;
    public AppenderSkeleton anAppender;
    public Level aLevel;
    public LoggerLevel aLoggerLevel;
    public boolean isNewLoggerARuleLogger = false;
    public boolean showAll = false;
    public int rowIndex = 0;
    private static final NSArray _pageSections = new NSArray<PageSection>(PageSection.values());
    public PageSection aPageSection;
    private PageSection _activeSection = PageSection.LOGGERS;
    public static final EOSortOrdering NAME_SORT_ORDERING = new EOSortOrdering("name", EOSortOrdering.CompareAscending);
    public static final NSMutableArray SORT_BY_NAME = new NSMutableArray<EOSortOrdering>(NAME_SORT_ORDERING);

    public ERXLog4JConfiguration(WOContext aContext) {
        super(aContext);
    }

    public Logger logger() {
        return this._logger;
    }

    public void setLogger(Logger newValue) {
        this._logger = newValue;
    }

    public String filterString() {
        return this._filterString;
    }

    public void setFilterString(String newValue) {
        this._filterString = newValue;
    }

    public String loggerName() {
        return this._loggerName;
    }

    public void setLoggerName(String newValue) {
        this._loggerName = newValue;
    }

    public String ruleKey() {
        return this._ruleKey;
    }

    public void setRuleKey(String newValue) {
        this._ruleKey = newValue;
    }

    public NSArray pageSections() {
        return _pageSections;
    }

    public String activeSection() {
        return this._activeSection.displayName();
    }

    public void setActiveSection(String name) {
        this._activeSection = PageSection.sectionWithId(name);
        if (null == this._activeSection) {
            this._activeSection = PageSection.LOGGERS;
        }
    }

    public NSArray loggers() {
        NSMutableArray result = new NSMutableArray();
        Enumeration e = this.allLoggers().objectEnumerator();
        while (e.hasMoreElements()) {
            for (Logger log = (Logger)e.nextElement(); log != null; log = (Logger)log.getParent()) {
                this.addLogger(log, result);
            }
        }
        return result;
    }

    private NSArray allLoggers() {
        NSMutableArray result = new NSMutableArray();
        Logger rootLogger = LogManager.getRootLogger();
        this.addLogger(rootLogger, result);
        NSMutableArray<Logger> otherLoggers = new NSMutableArray<Logger>();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            for (Logger log = (Logger)e.nextElement(); log != null; log = (Logger)log.getParent()) {
                if (log == rootLogger) continue;
                otherLoggers.addObject(log);
            }
        }
        EOSortOrdering.sortArrayUsingKeyOrderArray(otherLoggers, (NSArray)SORT_BY_NAME);
        result.addObjectsFromArray(otherLoggers);
        return result;
    }

    public void addLogger(Logger log, NSMutableArray result) {
        if (!result.containsObject(log)) {
            boolean passesFilterString = false;
            boolean passesFilterLevel = false;
            if (!(this.filterString() != null && this.filterString().length() != 0 && log.getName().toLowerCase().indexOf(this.filterString().toLowerCase()) == -1 || !this.showAll && log.getLevel() == null)) {
                passesFilterString = true;
            }
            if (null == this.filterLevel || LoggerLevel.loggerLevelForLog4JLevel(log.getLevel()) == this.filterLevel) {
                passesFilterLevel = true;
            }
            if (passesFilterString && passesFilterLevel) {
                result.addObject(log);
            }
        }
    }

    public LoggerLevel currentLoggerLevel() {
        return this._logger != null ? LoggerLevel.loggerLevelForLog4JLevel(this._logger.getLevel()) : LoggerLevel.UNSET;
    }

    public void setCurrentLoggerLevel(LoggerLevel loggerLevel) {
        this._logger.setLevel(loggerLevel.level());
    }

    public String classNameForLoggerLevelName() {
        NSMutableArray<String> classes = new NSMutableArray<String>();
        if (this.aLoggerLevel == LoggerLevel.UNSET) {
            classes.addObject("unset");
        }
        if (this.currentLoggerLevel() == this.aLoggerLevel) {
            classes.addObject("selected");
        }
        return classes.componentsJoinedByString(" ");
    }

    public String classForLoggerRow() {
        NSMutableArray<String> array = new NSMutableArray<String>();
        Level level = this.logger().getLevel();
        if (level != null) {
            array.addObject(level.toString().toLowerCase());
        }
        if (this.rowIndex % 2 == 0) {
            array.addObject("alt");
        }
        return array.componentsJoinedByString(" ");
    }

    public boolean omitLoggerLevelSettingDecoration() {
        return this.classNameForLoggerLevelName().length() == 0;
    }

    public NSArray loggerLevels() {
        return new NSArray<LoggerLevel>(LoggerLevel.values());
    }

    public NSArray loggerLevelsWithoutUnset() {
        return ERXArrayUtilities.arrayMinusObject(new NSArray<LoggerLevel>(LoggerLevel.values()), (Object)LoggerLevel.UNSET);
    }

    public LoggerRepository loggerRepository() {
        return LogManager.getLoggerRepository();
    }

    public String classNameForLoggerRepositoryThresholdName() {
        return this.loggerRepository().getThreshold() == this.aLevel ? "selected" : null;
    }

    public boolean omitLoggerRepositoryThresholdSettingDecoration() {
        return null == this.classNameForLoggerRepositoryThresholdName();
    }

    public NSArray appenders() {
        if (null == this._appenders) {
            TreeSet<AppenderSkeleton> appenders = new TreeSet<AppenderSkeleton>(new Comparator<AppenderSkeleton>(){

                @Override
                public int compare(AppenderSkeleton o1, AppenderSkeleton o2) {
                    int result = 0;
                    if (o1 == o2) {
                        result = 0;
                    } else {
                        String name2;
                        String name1 = o1.getName();
                        if (name1.equals(name2 = o2.getName())) {
                            name1 = o1.getName() + "_" + o1.hashCode();
                            name2 = o2.getName() + "_" + o2.hashCode();
                        }
                        result = name1.compareTo(name2);
                    }
                    return result;
                }
            });
            Logger rootLogger = LogManager.getRootLogger();
            Enumeration rootAppendersEnum = rootLogger.getAllAppenders();
            while (rootAppendersEnum.hasMoreElements()) {
                Appender appender = (Appender)rootAppendersEnum.nextElement();
                if (!(appender instanceof AppenderSkeleton)) continue;
                appenders.add((AppenderSkeleton)appender);
            }
            Enumeration loggersEnum = LogManager.getCurrentLoggers();
            while (loggersEnum.hasMoreElements()) {
                Logger logger = (Logger)loggersEnum.nextElement();
                Enumeration appendersEnum = logger.getAllAppenders();
                while (appendersEnum.hasMoreElements()) {
                    Appender appender = (Appender)appendersEnum.nextElement();
                    if (!(appender instanceof AppenderSkeleton)) continue;
                    appenders.add((AppenderSkeleton)appender);
                }
            }
            this._appenders = new NSArray<Object>(appenders.toArray());
        }
        return this._appenders;
    }

    public NSArray levelsWithoutUnset() {
        NSArray<LoggerLevel> applicableLevels = ERXArrayUtilities.arrayMinusObject(new NSArray<LoggerLevel>(LoggerLevel.values()), (Object)LoggerLevel.UNSET);
        return (NSArray)applicableLevels.valueForKey("level");
    }

    public LoggerLevel currentAppenderLevel() {
        Priority threshold = this.anAppender.getThreshold();
        return LoggerLevel.loggerLevelForLog4JLevel(threshold != null ? Level.toLevel((int)threshold.toInt()) : null);
    }

    public void setCurrentAppenderLevel(LoggerLevel loggerLevel) {
        this.anAppender.setThreshold((Priority)loggerLevel.level());
    }

    public String classForAppenderRow() {
        NSMutableArray<Object> array = new NSMutableArray<Object>();
        Level level = this.currentAppenderLevel().level();
        if (level != null) {
            array.addObject(level);
        }
        if (this.rowIndex % 2 == 0) {
            array.addObject("alt");
        }
        return array.componentsJoinedByString(" ");
    }

    public String classNameForAppenderThresholdName() {
        NSMutableArray<String> classes = new NSMutableArray<String>();
        if (this.aLoggerLevel == LoggerLevel.UNSET) {
            classes.addObject("unset");
        }
        if (this.currentAppenderLevel() == this.aLoggerLevel) {
            classes.addObject("selected");
        }
        return classes.componentsJoinedByString(" ");
    }

    public boolean omitAppenderThresholdSettingDecoration() {
        return null == this.classNameForAppenderThresholdName();
    }

    public WOComponent updateAppenderSettings() {
        return null;
    }

    public WOComponent updateRepositorySettings() {
        return null;
    }

    public WOComponent filter() {
        return null;
    }

    public WOComponent resetFilter() {
        this._filterString = null;
        this.filterLevel = null;
        return null;
    }

    public WOComponent update() {
        ERXExtensions.configureAdaptorContext();
        return null;
    }

    public String showAllLoggersSelection() {
        return this.showAll ? "all" : "explicit";
    }

    public void setShowAllLoggersSelection(String value) {
        this.showAll = "all".equals(value);
    }

    public WOComponent addLogger() {
        if (this.isNewLoggerARuleLogger) {
            this._addRuleKeyLogger();
        } else {
            this._addLogger();
        }
        return null;
    }

    private void _addLogger() {
        Logger log = Logger.getLogger((String)this.loggerName());
        if (this.newLoggerLevel != null) {
            this.filterLevel = this.newLoggerLevel;
            log.setLevel(this.newLoggerLevel.level());
        } else {
            this.showAll = true;
            this.filterLevel = null;
        }
        this.setFilterString(this.loggerName());
    }

    private void _addRuleKeyLogger() {
        String prefix = "er.directtoweb.rules." + this.loggerName();
        Logger ruleFireLog = Logger.getLogger((String)(prefix + ".fire"));
        Logger ruleCacheHitLog = Logger.getLogger((String)(prefix + ".cache"));
        Logger ruleCandidatesLog = Logger.getLogger((String)(prefix + ".candidates"));
        if (this.newLoggerLevel != null) {
            this.filterLevel = this.newLoggerLevel;
            Level level = this.newLoggerLevel.level();
            ruleFireLog.setLevel(level);
            ruleCacheHitLog.setLevel(level);
            ruleCandidatesLog.setLevel(level);
        } else {
            this.showAll = true;
            this.filterLevel = null;
        }
        this.setFilterString(prefix);
    }

    public String loggerPropertiesString() {
        String result = "";
        Enumeration e = this.allLoggers().objectEnumerator();
        while (e.hasMoreElements()) {
            Logger log = (Logger)e.nextElement();
            String name = log.getName();
            Level level = log.getLevel();
            if (level == null || "root".equals(name)) continue;
            result = result + "log4j.logger." + log.getName() + "=" + log.getLevel() + "\n";
        }
        return result;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        if (this.session().objectForKey("ERXLog4JConfiguration.enabled") != null) {
            super.appendToResponse(response, context);
        } else {
            response.appendContentString("please use the ERXDirectAction log4jAction to login first!");
        }
    }

    public String conversionPattern() {
        return ERXPatternLayout.instance().getConversionPattern();
    }

    public void setConversionPattern(String newPattern) {
        ERXPatternLayout.instance().setConversionPattern(newPattern);
    }

    public WOComponent updateConversionPattern() {
        return null;
    }

    public String classForNavItem() {
        return this.aPageSection == this._activeSection ? "active" : null;
    }

    public String classForLoggersDiv() {
        return PageSection.LOGGERS == this._activeSection ? "active" : null;
    }

    public String classForRepositoryDiv() {
        return PageSection.REPOSITORY == this._activeSection ? "active" : null;
    }

    public String classForAppendersDiv() {
        return PageSection.APPENDERS == this._activeSection ? "active" : null;
    }

    public String classForOtherSettingsDiv() {
        return PageSection.OTHER == this._activeSection ? "active" : null;
    }

    public String classForLoggerConfigurationControlBar() {
        return PageSection.LOGGERS == this._activeSection ? "active" : null;
    }

    public void awake() {
        super.awake();
        this._appenders = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PageSection {
        LOGGERS("Loggers", "Loggers"),
        REPOSITORY("Repository", "Repository"),
        APPENDERS("Appenders", "Appenders"),
        OTHER("Other", "Other Settings");

        private String displayName;
        private String id;
        private static Map<String, PageSection> sectionsById;

        private PageSection(String id, String displayName) {
            this.displayName = displayName;
            this.id = id;
        }

        public String displayName() {
            return this.displayName;
        }

        public String id() {
            return this.id;
        }

        public static PageSection sectionWithId(String name) {
            return sectionsById.get(name);
        }

        static {
            sectionsById = new HashMap<String, PageSection>(4);
            for (PageSection section : PageSection.values()) {
                sectionsById.put(section.id(), section);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum LoggerLevel {
        ALL(Level.ALL, "All"),
        TRACE(Level.TRACE, "Trace"),
        DEBUG(Level.DEBUG, "Debug"),
        INFO(Level.INFO, "Info"),
        WARN(Level.WARN, "Warn"),
        ERROR(Level.ERROR, "Error"),
        FATAL(Level.FATAL, "Fatal"),
        OFF(Level.OFF, "Off"),
        UNSET(null, "Unset");

        private Level level;
        private String displayName;
        private static Map<Level, LoggerLevel> levelsByLog4JLevel;

        private LoggerLevel(Level level, String displayName) {
            this.level = level;
            this.displayName = displayName;
        }

        public Level level() {
            return this.level;
        }

        public String displayName() {
            return this.displayName;
        }

        public static LoggerLevel loggerLevelForLog4JLevel(Level level) {
            return levelsByLog4JLevel.get(level);
        }

        static {
            levelsByLog4JLevel = new HashMap<Level, LoggerLevel>(8);
            for (LoggerLevel level : LoggerLevel.values()) {
                levelsByLog4JLevel.put(level.level(), level);
            }
        }
    }
}

