/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.logging;

import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXSystem;
import er.extensions.logging.ERXNSLogLog4jBridge;
import er.extensions.logging.ERXPatternLayout;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.spi.LoggerFactory;

public class ERXLogger
extends Logger {
    public static final String CONFIGURE_LOGGING_WITH_SYSTEM_PROPERTIES = "configureLoggingWithSystemProperties";
    public static Logger log;
    public static Factory factory;

    public static ERXLogger getERXLogger(String name) {
        Logger logger = ERXLogger.getLogger(name);
        if (logger != null && !(logger instanceof ERXLogger)) {
            ERXLogger.configureLoggingWithSystemProperties();
            logger = ERXLogger.getLogger(name);
        }
        if (logger != null && !(logger instanceof ERXLogger)) {
            throw new RuntimeException("Can't load Logger for \"" + name + "\" because it is not of class ERXLogger but \"" + logger.getClass().getName() + "\". Let your Application class inherit from ERXApplication or call ERXLog4j.configureLogging() statically the first thing in your app. \nAlso check if there is a \"log4j.loggerFactory=er.extensions.Logger$Factory\" line in your properties.");
        }
        return (ERXLogger)logger;
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger((String)name, (LoggerFactory)factory);
    }

    public static ERXLogger getERXLogger(Class clazz) {
        return ERXLogger.getERXLogger(clazz.getName());
    }

    public static Logger getLogger(Class clazz) {
        return ERXLogger.getERXLogger(clazz);
    }

    public static ERXLogger getERXLogger(Class clazz, String subTopic) {
        return ERXLogger.getERXLogger(clazz.getName() + (subTopic != null && subTopic.length() > 0 ? "." + subTopic : null));
    }

    public ERXLogger(String name) {
        super(name);
    }

    public static synchronized void configureLoggingWithSystemProperties() {
        ERXLogger.configureLogging(ERXSystem.getProperties());
    }

    public static synchronized void configureLogging(Properties properties) {
        LogManager.resetConfiguration();
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.INFO);
        boolean is522OrHigher = ERXProperties.webObjectsVersionIs522OrHigher();
        if (is522OrHigher) {
            int allowedLevel = NSLog.debug.allowedDebugLevel();
            if (!(NSLog.debug instanceof ERXNSLogLog4jBridge)) {
                NSLog.setOut((NSLog.Logger)new ERXNSLogLog4jBridge(1));
                NSLog.setErr((NSLog.Logger)new ERXNSLogLog4jBridge(2));
                NSLog.setDebug((NSLog.Logger)new ERXNSLogLog4jBridge(3));
            }
            NSLog.debug.setAllowedDebugLevel(allowedLevel);
        }
        PropertyConfigurator.configure((Properties)properties);
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            ConsoleAppender appender = new ConsoleAppender((Layout)new ERXPatternLayout("%-5p %d{HH:mm:ss} (%-20c:%L):  %m%n"), "System.out");
            Logger.getRootLogger().addAppender((Appender)appender);
            Logger.getRootLogger().setLevel(Level.DEBUG);
            Logger.getRootLogger().error((Object)"Logging prefs couldn't get read from properties, using defaults");
        }
        if (log == null) {
            log = Logger.getLogger((String)Logger.class.getName());
        }
        log.info((Object)"Updated the logging configuration with the current system properties.");
        if (log.isDebugEnabled()) {
            log.debug((Object)("log4j.loggerFactory: " + System.getProperty("log4j.loggerFactory")));
            log.debug((Object)("Factory: " + factory));
        }
        if (factory != null) {
            factory.loggingConfigurationDidChange();
        }
        NSNotificationCenter.defaultCenter().postNotification("ConfigurationDidChangeNotification", null);
    }

    public void debugStackTrace(Throwable throwable) {
        if (this.isDebugEnabled()) {
            throwable.printStackTrace();
        }
    }

    static {
        factory = null;
        String factoryClassName = System.getProperty("log4j.loggerFactory");
        if (factoryClassName == null) {
            factoryClassName = Factory.class.getName();
        }
        if (factoryClassName.indexOf("ERXLogger$Factory") >= 0) {
            System.getProperties().remove("log4j.loggerFactory");
            factoryClassName = null;
        }
        if (factoryClassName != null) {
            try {
                factory = (Factory)Class.forName(factoryClassName).newInstance();
            }
            catch (Exception ex) {
                System.err.println("Exception while creating logger factory of class " + factoryClassName + ": " + ex);
            }
        }
    }

    public static class Factory
    implements LoggerFactory {
        public Logger makeNewLoggerInstance(String name) {
            if (log != null && log.isDebugEnabled()) {
                log.debug((Object)("makeNewLoggerInstance: " + name));
            }
            return new ERXLogger(name);
        }

        public void loggingConfigurationDidChange() {
        }
    }
}

