/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.migration;

import com.webobjects.eoaccess.EOAdaptor;
import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eoaccess.EOSynchronizationFactory;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.foundation.ERXProperties;
import er.extensions.jdbc.ERXJDBCUtilities;
import er.extensions.migration.ERXMigrationColumn;
import er.extensions.migration.ERXMigrationFailedException;
import er.extensions.migration.ERXMigrationTable;
import er.extensions.migration.ERXModelVersion;
import er.extensions.migration.IERXMigration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXMigrationDatabase {
    public static final Logger log = Logger.getLogger(ERXMigrationDatabase.class);
    private EOModel _model;
    private EOAdaptorChannel _adaptorChannel;
    private NSMutableArray<ERXMigrationTable> _tables;
    private NSArray<String> _languages;

    private ERXMigrationDatabase(EOAdaptorChannel adaptorChannel, EOModel model) {
        this(adaptorChannel, model, ERXProperties.arrayForKey("ERXLanguages"));
    }

    private ERXMigrationDatabase(EOAdaptorChannel adaptorChannel, EOModel model, NSArray<String> languages) {
        this._adaptorChannel = adaptorChannel;
        this._model = model;
        this._tables = new NSMutableArray();
        this._languages = languages;
        if (model.userInfo().objectForKey("ERXLanguages") != null) {
            this._languages = ERXProperties.arrayForKey("ERXLanguages");
        }
    }

    public EOSynchronizationFactory synchronizationFactory() {
        return (EOSynchronizationFactory)this.adaptor().synchronizationFactory();
    }

    public EOAdaptor adaptor() {
        return this._adaptorChannel.adaptorContext().adaptor();
    }

    public EOModel model() {
        return this._model;
    }

    public NSArray<String> languages() {
        return this._languages == null ? NSArray.EmptyArray : this._languages;
    }

    public EOAdaptorChannel adaptorChannel() {
        return this._adaptorChannel;
    }

    public ERXMigrationTable existingTableNamed(String name) {
        ERXMigrationTable table;
        NSArray existingTables = EOQualifier.filteredArrayWithQualifier(this._tables, (EOQualifier)new EOKeyValueQualifier("name", EOQualifier.QualifierOperatorCaseInsensitiveLike, (Object)name));
        if (existingTables.count() == 0) {
            table = new ERXMigrationTable(this, name);
            table._setNew(false);
            this._tables.addObject(table);
        } else {
            table = (ERXMigrationTable)existingTables.objectAtIndex(0);
        }
        return table;
    }

    public ERXMigrationColumn existingColumnNamed(String tableName, String columnName) {
        ERXMigrationTable table = this.existingTableNamed(tableName);
        return table.existingColumnNamed(columnName);
    }

    public ERXMigrationTable newTableNamed(String name) {
        NSArray existingTables = EOQualifier.filteredArrayWithQualifier(this._tables, (EOQualifier)new EOKeyValueQualifier("name", EOQualifier.QualifierOperatorCaseInsensitiveLike, (Object)name));
        if (existingTables.count() > 0) {
            throw new IllegalArgumentException("You've already referenced a table named '" + name + "'.");
        }
        ERXMigrationTable newTable = new ERXMigrationTable(this, name);
        this._tables.addObject(newTable);
        return newTable;
    }

    public EOModel _blankModel() {
        EOModel blankModel = new EOModel();
        NSDictionary connectionDictionary = null;
        if (this._model != null) {
            connectionDictionary = this._model.connectionDictionary();
        }
        if (connectionDictionary == null) {
            connectionDictionary = this._adaptorChannel.adaptorContext().adaptor().connectionDictionary();
        }
        blankModel.setConnectionDictionary(connectionDictionary);
        blankModel.setAdaptorName(this._adaptorChannel.adaptorContext().adaptor().name());
        return blankModel;
    }

    public void _tableDropped(ERXMigrationTable table) {
        this._tables.removeObject(table);
    }

    public boolean is(String name) {
        return this.productName().equals(name);
    }

    public String productName() {
        return ERXJDBCUtilities.databaseProductName(this.adaptorChannel());
    }

    public static ERXMigrationDatabase database(EOAdaptorChannel adaptorChannel) {
        return new ERXMigrationDatabase(adaptorChannel, null);
    }

    public static ERXMigrationDatabase database(EOAdaptorChannel adaptorChannel, EOModel model, NSArray<String> languages) {
        return new ERXMigrationDatabase(adaptorChannel, model, languages);
    }

    public static ERXMigrationDatabase database(EOAdaptorChannel adaptorChannel, EOModel model) {
        return new ERXMigrationDatabase(adaptorChannel, model);
    }

    public static void _ensureNotEmpty(NSArray<EOSQLExpression> expressions, String operationName, boolean required) {
        if (expressions == null || expressions.count() == 0) {
            if (required) {
                throw new ERXMigrationFailedException("Your EOSynchronizationFactory does not support the required '" + operationName + "' operation.");
            }
            log.error((Object)("Your EOSynchronizationFactory does not support the '" + operationName + "' operation, so this migration will be skipped."));
        }
    }

    public static NSArray<String> _stringsForExpressions(NSArray<EOSQLExpression> expressions) {
        return (NSArray)expressions.valueForKey("statement");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Migration
    implements IERXMigration {
        public static final boolean ALLOWS_NULL = true;
        public static final boolean NOT_NULL = false;
        private NSArray<String> _languages;

        protected Migration() {
            this(null);
        }

        protected Migration(NSArray languages) {
            this._languages = languages;
        }

        public NSArray<String> languages() {
            return this._languages;
        }

        @Override
        public void downgrade(EOEditingContext editingContext, EOAdaptorChannel channel, EOModel model) throws Throwable {
            this.downgrade(editingContext, ERXMigrationDatabase.database(channel, model, this._languages));
        }

        public abstract void downgrade(EOEditingContext var1, ERXMigrationDatabase var2) throws Throwable;

        @Override
        public NSArray<ERXModelVersion> modelDependencies() {
            return null;
        }

        @Override
        public void upgrade(EOEditingContext editingContext, EOAdaptorChannel channel, EOModel model) throws Throwable {
            this.upgrade(editingContext, ERXMigrationDatabase.database(channel, model, this._languages));
        }

        public abstract void upgrade(EOEditingContext var1, ERXMigrationDatabase var2) throws Throwable;
    }
}

