/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.statistics;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSet;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXUtilities;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXStats {
    private static final String STATS_INITIALIZED_KEY = "er.extensions.erxStats.initialized";
    private static final String STATS_START_TIME_KEY = "er.extensions.erxStats.startTime";
    private static final String STATS_LAST_TIME_KEY = "er.extensions.erxStats.lastTime";
    private static final String STATS_MAX_KEY = "er.extensions.erxStats.max";
    private static final String STATS_KEY = "er.extensions.erxStats.statistics";
    public static final String STATS_ENABLED_KEY = "er.extensions.erxStats.enabled";
    public static final String STATS_TRACE_COLLECTING_ENABLED_KEY = "er.extensions.erxStats.traceCollectingEnabled";
    public static final Logger log = Logger.getLogger(ERXStats.class);
    private static NSMutableArray<NSMutableDictionary<String, LogEntry>> _allStatistics = new NSMutableArray();

    public static void initStatisticsIfNecessary() {
        if (ERXStats.areStatisticsEnabled()) {
            ERXStats.initStatistics();
        }
    }

    private static boolean areStatisticsEnabled() {
        return ERXProperties.booleanForKey(STATS_ENABLED_KEY);
    }

    public static boolean traceCollectingEnabled() {
        return ERXProperties.booleanForKeyWithDefault(STATS_TRACE_COLLECTING_ENABLED_KEY, false);
    }

    public static void initStatistics() {
        ERXThreadStorage.takeValueForKey(Boolean.TRUE, STATS_INITIALIZED_KEY);
        ERXThreadStorage.takeValueForKey(new Long(System.currentTimeMillis()), STATS_START_TIME_KEY);
        ERXThreadStorage.removeValueForKey(STATS_LAST_TIME_KEY);
        ERXThreadStorage.removeValueForKey(STATS_KEY);
    }

    public static boolean isTrackingStatistics() {
        Boolean statsInitialized = (Boolean)ERXThreadStorage.valueForKey(STATS_INITIALIZED_KEY);
        return statsInitialized != null && statsInitialized != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSMutableDictionary<String, LogEntry> statistics() {
        NSMutableDictionary statistics = (NSMutableDictionary)ERXThreadStorage.valueForKey(STATS_KEY);
        if (statistics == null) {
            statistics = new NSMutableDictionary();
            ERXThreadStorage.takeValueForKey(statistics, STATS_KEY);
            NSMutableArray<NSMutableDictionary<String, LogEntry>> nSMutableArray = _allStatistics;
            synchronized (nSMutableArray) {
                _allStatistics.addObject(statistics);
                int maxStatistics = ERXProperties.intForKeyWithDefault(STATS_MAX_KEY, 1000);
                if (_allStatistics.count() > maxStatistics) {
                    _allStatistics.removeObjectAtIndex(0);
                }
            }
        }
        return statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogEntry logEntryForKey(String key) {
        LogEntry entry = null;
        NSMutableDictionary<String, LogEntry> statistics = ERXStats.statistics();
        if (statistics != null) {
            NSMutableDictionary<String, LogEntry> nSMutableDictionary = statistics;
            synchronized (nSMutableDictionary) {
                entry = (LogEntry)statistics.objectForKey(key);
                if (entry == null) {
                    entry = new LogEntry(key);
                    statistics.setObjectForKey(entry, key);
                }
            }
        }
        return entry;
    }

    public static LogEntry logEntryForKey(String group, String key) {
        return ERXStats.logEntryForKey(ERXStats.makeKey(group, key));
    }

    public static NSSet<String> aggregateKeys() {
        NSMutableSet<String> keys = new NSMutableSet<String>();
        for (NSMutableDictionary<String, LogEntry> statistics : _allStatistics) {
            keys.addObjectsFromArray(statistics.allKeys());
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LogEntry aggregateLogEntryForKey(String key) {
        LogEntry aggregateLogEntry = new LogEntry(key);
        if (key != null) {
            NSMutableArray<NSMutableDictionary<String, LogEntry>> nSMutableArray = _allStatistics;
            synchronized (nSMutableArray) {
                for (NSMutableDictionary<String, LogEntry> statistics : _allStatistics) {
                    LogEntry logEntry = (LogEntry)statistics.objectForKey(key);
                    if (logEntry == null) continue;
                    aggregateLogEntry._add(logEntry);
                }
            }
        }
        return aggregateLogEntry;
    }

    public static NSArray<LogEntry> aggregateLogEntries() {
        NSMutableArray<LogEntry> aggregateLogEntries = new NSMutableArray<LogEntry>();
        for (String key : ERXStats.aggregateKeys()) {
            LogEntry logEntry = ERXStats.aggregateLogEntryForKey(key);
            if (logEntry == null) continue;
            aggregateLogEntries.addObject(logEntry);
        }
        return aggregateLogEntries;
    }

    public static void markStart(String group, String key) {
        LogEntry entry = ERXStats.logEntryForKey(ERXStats.makeKey(group, key));
        if (entry != null) {
            entry.start();
        }
    }

    public static void markStart(String key) {
        ERXStats.markStart(" ", key);
    }

    public static void markEnd(String group, String key) {
        LogEntry entry = ERXStats.logEntryForKey(ERXStats.makeKey(group, key));
        if (entry != null) {
            entry.end();
        }
    }

    public static void markEnd(String key) {
        ERXStats.markEnd(" ", key);
    }

    public static void addDurationForKey(long duration, String key) {
        ERXStats.addDurationForKey(duration, " ", key);
    }

    public static void addDurationForKey(long duration, String group, String key) {
        LogEntry entry = ERXStats.logEntryForKey(ERXStats.makeKey(group, key));
        if (entry != null) {
            entry.add(duration);
        }
    }

    private static String makeKey(String group, String key) {
        return group != null ? group + "." + key : key;
    }

    public static synchronized void reset() {
        _allStatistics.removeAllObjects();
        ERXThreadStorage.removeValueForKey(STATS_KEY);
    }

    public static void logStatisticsForOperation(String operation) {
        ERXStats.logStatisticsForOperation(log, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logStatisticsForOperation(Logger statsLog, String operation) {
        NSMutableDictionary<String, LogEntry> statistics;
        if (statsLog.isDebugEnabled() && (statistics = ERXStats.statistics()) != null) {
            NSMutableDictionary<String, LogEntry> nSMutableDictionary = statistics;
            synchronized (nSMutableDictionary) {
                NSArray values = ERXArrayUtilities.sortedArraySortedWithKey(statistics.allValues(), operation);
                if (values.count() > 0) {
                    Long startTime = (Long)ERXThreadStorage.valueForKey(STATS_START_TIME_KEY);
                    Long lastTime = (Long)ERXThreadStorage.valueForKey(STATS_LAST_TIME_KEY);
                    long currentTime = System.currentTimeMillis();
                    String result = NSPropertyListSerialization.stringFromPropertyList(values);
                    statsLog.debug((Object)((startTime != null ? "Time since init " + (currentTime - startTime) + " ms" : "") + (lastTime != null ? ", last log " + (currentTime - lastTime) + " ms" : "") + ", total cnt/sum: " + statistics.allValues().valueForKeyPath("@sum.count") + "/" + statistics.allValues().valueForKeyPath("@sum.sum") + " (cnt/sum : min/max/avg|trace cnt -> key) = " + result));
                    ERXThreadStorage.takeValueForKey(new Long(currentTime), STATS_LAST_TIME_KEY);
                }
            }
        }
    }

    public static class LogEntry {
        private float _avg;
        private long _count;
        private long _min;
        private long _max;
        private long _sum;
        private long _latestDuration;
        private String _key;
        private Set<String> _traces = Collections.synchronizedSet(new HashSet());
        private NSArray<String> _traceArray = null;
        private long _lastMark;

        public LogEntry(String key) {
            this._key = key;
            this._avg = -1.0f;
            this._min = Long.MAX_VALUE;
            this._latestDuration = -1L;
        }

        public synchronized void _add(LogEntry logEntry) {
            long originalCount = this._count;
            if (logEntry._min < this._min) {
                this._min = logEntry._min;
            }
            if (logEntry._max > this._max) {
                this._max = logEntry._max;
            }
            this._sum += logEntry._sum;
            this._count += logEntry._count;
            this._avg = -1.0f;
            this._traces.addAll(logEntry._traces);
            this._traceArray = null;
        }

        public synchronized long count() {
            return this._count;
        }

        public synchronized long min() {
            return this._min;
        }

        public synchronized long max() {
            return this._max;
        }

        public synchronized long sum() {
            return this._sum;
        }

        public synchronized long latestDuration() {
            return this._latestDuration;
        }

        public synchronized void start() {
            this._lastMark = System.currentTimeMillis();
        }

        public synchronized void end() {
            if (this._lastMark > 0L) {
                this.add(System.currentTimeMillis() - this._lastMark);
                this._lastMark = 0L;
            } else {
                log.info((Object)"You called ERXStats.end before calling ERXStats.start.");
            }
        }

        public synchronized void add(long time) {
            this._latestDuration = time;
            if (time < this._min) {
                this._min = time;
            }
            if (time > this._max) {
                this._max = time;
            }
            ++this._count;
            this._sum += time;
            this._avg = -1.0f;
            if (ERXStats.traceCollectingEnabled()) {
                String trace = ERXUtilities.stackTrace();
                this._traces.add(trace);
                this._traceArray = null;
            }
        }

        public synchronized float avg() {
            if (this._avg < 0.0f) {
                this._avg = this._count == 0L ? 0.0f : (float)this._sum / (float)this._count;
            }
            return this._avg;
        }

        public String key() {
            return this._key;
        }

        public NSArray traces() {
            if (this._traceArray == null) {
                NSMutableSet<String> traces = new NSMutableSet<String>();
                for (String trace : this._traces) {
                    trace = trace.replaceAll("at\\s+(com.webobjects|java|er|sun)\\..*?\\n", "...\n");
                    trace = trace.replaceAll("(\\.\\.\\.\\s+)+", "...\n\t");
                    traces.addObject(trace);
                }
                this._traceArray = traces.allObjects();
            }
            return this._traceArray;
        }

        public String toString() {
            return this.count() + "/" + this.sum() + " : " + this.min() + "/" + this.max() + "/" + new BigDecimal(this.avg(), MathContext.DECIMAL32).setScale(2, 6) + "|" + this._traces.size() + "->" + this._key;
        }
    }

    public static interface Group {
        public static final String Default = " ";
        public static final String SQL = "SQL";
        public static final String Component = "Component";
        public static final String ComponentTakeValuesFromRequest = "Component (takeValuesFromRequest)";
        public static final String ComponentInvokeAction = "Component (invokeAction)";
        public static final String Batching = "Batching";
    }
}

