/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.validation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXMultiKey;
import er.extensions.foundation.ERXSimpleTemplateParser;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.validation.ERXValidation;
import er.extensions.validation.ERXValidationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ERXValidationFactory {
    public static final Logger log = Logger.getLogger(ERXValidationFactory.class);
    private static ERXValidationFactory _defaultFactory;
    private static Object _defaultValidationDelegate;
    private static NSDictionary _mappings;
    public static final String VALIDATION_TEMPLATE_PREFIX = "ValidationTemplate.";
    private static final String EDI_MFE_METHOD_NAME = "messageForException";
    private static final String EDI_TFE_METHOD_NAME = "templateForException";
    private static final Class[] EDI_FE_ARGS;
    private static Class[] _regularConstructor;
    private static final String UNDEFINED_VALIDATION_TEMPLATE = "Undefined Validation Template";
    private Class _validationExceptionClass;
    private Hashtable _cache = new Hashtable(1000);
    private String _delimiter = "@@";
    protected Constructor regularConstructor;

    public static void setDefaultFactory(ERXValidationFactory aFactory) {
        _defaultFactory = aFactory;
    }

    public static ERXValidationFactory defaultFactory() {
        if (_defaultFactory == null) {
            ERXValidationFactory.setDefaultFactory(new ERXValidationFactory());
        }
        return _defaultFactory;
    }

    public static Object defaultDelegate() {
        return _defaultValidationDelegate;
    }

    public static void setDefaultDelegate(Object obj) {
        _defaultValidationDelegate = obj;
    }

    public void setValidationExceptionClass(Class class1) {
        this._validationExceptionClass = class1;
    }

    public Class validationExceptionClass() {
        if (this._validationExceptionClass == null) {
            this._validationExceptionClass = ERXValidationException.class;
        }
        return this._validationExceptionClass;
    }

    protected Constructor regularValidationExceptionConstructor() {
        if (this.regularConstructor == null) {
            try {
                this.regularConstructor = this.validationExceptionClass().getConstructor(_regularConstructor);
            }
            catch (Exception e) {
                log.error((Object)"Exception looking up regular constructor.", (Throwable)e);
            }
        }
        return this.regularConstructor;
    }

    public ERXValidationException createException(EOEnterpriseObject eo, String property, Object value, String type) {
        ERXValidationException erve = null;
        try {
            log.debug((Object)("Creating exception for type: " + type + " validationExceptionClass: " + this.validationExceptionClass().getName()));
            erve = (ERXValidationException)((Object)this.regularValidationExceptionConstructor().newInstance(type, eo, property, value));
        }
        catch (InvocationTargetException ite) {
            log.error((Object)("Caught InvocationTargetException creating regular validation exception: " + ite.getTargetException()));
        }
        catch (Exception e) {
            log.error((Object)("Caught exception creating regular validation exception: " + e));
        }
        return erve;
    }

    public boolean shouldRecreateException(ERXValidationException erv, Object value) {
        return false;
    }

    public ERXValidationException createCustomException(EOEnterpriseObject eo, String method) {
        return this.createCustomException(eo, null, null, method);
    }

    public ERXValidationException createCustomException(EOEnterpriseObject eo, String property, Object value, String method) {
        ERXValidationException erv = this.createException(eo, property, value, "CustomMethodException");
        if (erv != null) {
            erv.setMethod(method);
        }
        return erv;
    }

    public ERXValidationException convertException(NSValidation.ValidationException eov) {
        return this.convertException(eov, null);
    }

    public ERXValidationException convertException(NSValidation.ValidationException eov, Object value) {
        ERXValidationException erve = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converting exception: " + (Object)((Object)eov) + " value: " + (value != null ? value : "<NULL>")));
        }
        if (!(eov instanceof ERXValidationException)) {
            String message = eov.getMessage();
            Object o = eov.object();
            EOEnterpriseObject eo = o instanceof EOEnterpriseObject ? (EOEnterpriseObject)o : null;
            Enumeration e = _mappings.allKeys().objectEnumerator();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String type = (String)_mappings.objectForKey(key);
                if (message.lastIndexOf(key) < 0) continue;
                String property = eov.key();
                if (property == null && message.indexOf("Removal") == 0) {
                    property = NSArray.componentsSeparatedByString(message, "'").objectAtIndex(3);
                }
                if (property == null && message.indexOf("Error encountered converting") == 0) {
                    property = NSArray.componentsSeparatedByString(message, "'").objectAtIndex(1);
                }
                erve = this.createException(eo, property, value, type);
                break;
            }
        } else {
            ERXValidationException original = (ERXValidationException)eov;
            if (this.shouldRecreateException(original, value)) {
                erve = this.createException(original.eoObject(), original.key(), original.value(), original.type());
                log.debug((Object)("Converting exception: " + (Object)((Object)original) + " value: " + (original.value() != null ? original.value() : "<NULL>")));
            } else {
                erve = original;
            }
        }
        if (erve == null) {
            log.error((Object)("Unable to convert validation exception: " + (Object)((Object)eov)), (Throwable)eov);
        } else {
            NSArray erveAdditionalExceptions = this.convertAdditionalExceptions(eov);
            if (erveAdditionalExceptions.count() > 0) {
                erve.setAdditionalExceptions(erveAdditionalExceptions);
            }
            if (erve != eov) {
                erve.setStackTrace(eov.getStackTrace());
            }
        }
        return erve;
    }

    protected NSArray convertAdditionalExceptions(NSValidation.ValidationException ex) {
        NSArray additionalExceptions = ex.additionalExceptions();
        if (additionalExceptions == null || additionalExceptions.count() == 0) {
            return NSArray.EmptyArray;
        }
        NSMutableArray<ERXValidationException> erveAdditionalExceptions = new NSMutableArray<ERXValidationException>();
        Enumeration e = additionalExceptions.objectEnumerator();
        while (e.hasMoreElements()) {
            ERXValidationException erven = this.convertException((NSValidation.ValidationException)((Object)e.nextElement()));
            if (erven == null) continue;
            erveAdditionalExceptions.addObject(erven);
        }
        return erveAdditionalExceptions;
    }

    public String messageForException(ERXValidationException erv) {
        String message = null;
        if (erv.delegate() != null && erv.delegate() instanceof ExceptionDelegateInterface) {
            message = ((ExceptionDelegateInterface)erv.delegate()).messageForException(erv);
        }
        if (message == null) {
            NSKeyValueCoding context = erv.context();
            String template = this.templateForException(erv);
            if (template.startsWith(UNDEFINED_VALIDATION_TEMPLATE)) {
                message = erv._getMessage();
                if (message == null) {
                    message = template;
                }
            } else {
                message = context == erv || context == null ? ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(template, this.templateDelimiter(), (Object)erv) : ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(template, this.templateDelimiter(), context, (Object)erv);
            }
        }
        return message;
    }

    public String templateForException(ERXValidationException erv) {
        String template = null;
        if (erv.delegate() != null && erv.delegate() instanceof ExceptionDelegateInterface) {
            template = ((ExceptionDelegateInterface)erv.delegate()).templateForException(erv);
        }
        if (template == null) {
            ERXMultiKey k;
            String entityName = erv.eoObject() == null ? null : erv.eoObject().entityName();
            String property = erv.isCustomMethodException() ? erv.method() : erv.propertyKey();
            String type = erv.type();
            String targetLanguage = erv.targetLanguage();
            if (targetLanguage == null) {
                String string = targetLanguage = ERXLocalizer.currentLocalizer() != null ? ERXLocalizer.currentLocalizer().language() : ERXLocalizer.defaultLanguage();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("templateForException with entityName: " + entityName + "; property: " + property + "; type: " + type + "; targetLanguage: " + targetLanguage));
            }
            if ((template = (String)this._cache.get(k = new ERXMultiKey(new Object[]{entityName, property, type, targetLanguage}))) == null) {
                template = this.templateForEntityPropertyType(entityName, property, type, targetLanguage);
                this._cache.put(k, template);
            }
        }
        return template;
    }

    public void resetTemplateCache(NSNotification n) {
        this._cache = new Hashtable(1000);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Resetting template cache");
        }
    }

    public NSKeyValueCoding contextForException(ERXValidationException erv) {
        NSKeyValueCoding context = null;
        if (erv.delegate() != null && erv.delegate() instanceof ExceptionDelegateInterface) {
            context = ((ExceptionDelegateInterface)erv.delegate()).contextForException(erv);
        }
        return context;
    }

    public String templateDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public void configureFactory() {
        ERXValidation.setPushChangesDefault(ERXValueUtilities.booleanValueWithDefault(ERXSystem.getProperty("er.extensions.ERXValidationShouldPushChangesToObject"), false));
        if (WOApplication.application() != null && !WOApplication.application().isCachingEnabled()) {
            NSNotificationCenter center = NSNotificationCenter.defaultCenter();
            center.addObserver((Object)this, new NSSelector("resetTemplateCache", ERXConstant.NotificationClassArray), "LocalizationDidReset", null);
        }
    }

    protected String templateForEntityPropertyType(String entityName, String property, String type, String targetLanguage) {
        String template;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up template for entity named \"" + entityName + "\" property \"" + property + "\" type \"" + type + "\" target language \"" + targetLanguage + "\""));
        }
        if ((template = this.templateForKeyPath(entityName + "." + property + "." + type, targetLanguage)) == null) {
            template = this.templateForKeyPath(entityName + "." + property, targetLanguage);
        }
        if (template == null) {
            template = this.templateForKeyPath(property + "." + type, targetLanguage);
        }
        if (template == null) {
            template = this.templateForKeyPath(property, targetLanguage);
        }
        if (template == null) {
            template = this.templateForKeyPath(type, targetLanguage);
        }
        if (template == null) {
            template = "Undefined Validation Template entity \"" + entityName + "\" property \"" + property + "\" type \"" + type + "\" target language \"" + targetLanguage + "\"";
            log.error((Object)template, new Throwable());
        }
        return template;
    }

    public String templateForKeyPath(String key, String language) {
        return (String)ERXLocalizer.localizerForLanguage(language).valueForKey(VALIDATION_TEMPLATE_PREFIX + key);
    }

    static {
        _defaultValidationDelegate = null;
        EDI_FE_ARGS = new Class[]{ERXValidationException.class};
        _regularConstructor = new Class[]{String.class, Object.class, String.class, Object.class};
        Object[] keys = new Object[]{"to be null", "Invalid Number", "must have a ", "must have at least one", "relationship, there is a related object", "relationship, there are related objects", "exceeds maximum length of", "Error encountered converting value of class"};
        Object[] objects = new Object[]{"NullPropertyException", "InvalidNumberException", "MandatoryToOneRelationshipException", "MandatoryToManyRelationshipException", "ObjectRemovalException", "ObjectsRemovalException", "ExceedsMaximumLengthException", "ValueConversionException"};
        _mappings = new NSDictionary<Object, Object>(objects, keys);
    }

    public static interface ExceptionDelegateInterface {
        public String messageForException(ERXValidationException var1);

        public String templateForException(ERXValidationException var1);

        public NSKeyValueCoding contextForException(ERXValidationException var1);
    }

    public static interface FactoryInterface {
        public Class validationExceptionClass();

        public void setValidationExceptionClass(Class var1);

        public ERXValidationException createException(EOEnterpriseObject var1, String var2, Object var3, String var4);

        public ERXValidationException createCustomException(EOEnterpriseObject var1, String var2);
    }
}

