/*
 * Decompiled with CFR 0.152.
 */
package er.testrunner;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import er.extensions.foundation.ERXPatcher;
import er.testrunner.ERXTestListener;
import er.testrunner.ERXTestResult;
import er.testrunner.ERXTestRunner;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.log4j.Logger;

public class ERXWOTestInterface
extends WOComponent
implements ERXTestListener {
    public static final Logger log = Logger.getLogger(ERXWOTestInterface.class);
    public String theTest = "";
    public String errorMessage = "";
    public Boolean showExceptions = Boolean.FALSE;
    public ERXTestRunner aTestRunner;
    public ERXTestResult testResult = null;
    public long runTime = 0L;
    public NSArray allTests;

    public ERXWOTestInterface(WOContext context) {
        super(context);
    }

    protected NSArray bundles() {
        NSMutableArray<NSBundle> bundles = new NSMutableArray<NSBundle>(NSBundle.frameworkBundles());
        bundles.addObject(NSBundle.mainBundle());
        return bundles;
    }

    public NSArray allTests() {
        if (this.allTests == null) {
            String thisBundleName = NSBundle.bundleForClass(this.getClass()).name();
            NSMutableSet<String> theClassNames = new NSMutableSet<String>();
            Enumeration bundleEnum = this.bundles().objectEnumerator();
            while (bundleEnum.hasMoreElements()) {
                NSBundle bundle = (NSBundle)bundleEnum.nextElement();
                if (bundle.name().equals(thisBundleName)) continue;
                Enumeration classNameEnum = bundle.bundleClassNames().objectEnumerator();
                while (classNameEnum.hasMoreElements()) {
                    String className = (String)classNameEnum.nextElement();
                    if (className == null || !className.endsWith("Test") && !className.endsWith("TestCase") && className.indexOf("tests.") != 0 && className.indexOf(".tests.") <= 0 || className.startsWith("junit.") || className.indexOf("$") >= 0) continue;
                    try {
                        Class c = ERXPatcher.classForName(className);
                        theClassNames.addObject(this.munge(className));
                    }
                    catch (Exception ex) {
                        log.warn((Object)("Skipping test " + className + ": " + ex));
                    }
                }
            }
            this.allTests = theClassNames.allObjects();
            try {
                this.allTests = this.allTests.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
            }
            catch (Exception ex) {
                log.warn((Object)ex);
            }
        }
        return this.allTests;
    }

    private String munge(String className) {
        String mungedName = className;
        int offset = className.lastIndexOf(46);
        if (offset >= 0) {
            mungedName = className.substring(offset + 1) + " - " + className.substring(0, offset);
        }
        return mungedName;
    }

    private String demunge(String className) {
        String demungedName = className;
        int offset = className.indexOf(" - ");
        if (offset >= 0) {
            demungedName = className.substring(offset + 3) + "." + className.substring(0, offset);
        }
        return demungedName;
    }

    private void resetInterface() {
        this.runTime = 0L;
        this.errorMessage = "";
        this.aTestRunner = new ERXTestRunner(this);
        this.testResult = new ERXTestResult();
        this.allTests = null;
    }

    public WOComponent performTest() {
        this.resetInterface();
        try {
            this.testResult = this.start();
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
        }
        return this.context().page();
    }

    public ERXTestResult start() throws Exception {
        if (this.theTest.equals("")) {
            throw new Exception("You need to provide the name of a class to use as the TestCase for this run.");
        }
        try {
            Test suite = this.aTestRunner.getTest(this.demunge(this.theTest));
            return this.doRun(suite);
        }
        catch (Exception e) {
            throw new Exception("Could not create and run test suite: " + e);
        }
    }

    public ERXTestResult doRun(Test suite) {
        this.testResult.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run((TestResult)this.testResult);
        long endTime = System.currentTimeMillis();
        this.runTime = endTime - startTime;
        return this.testResult;
    }

    public synchronized void addError(Test test, Throwable t) {
        log.error((Object)("[E] " + test.toString() + " : " + t.getMessage()), t);
    }

    public synchronized void addFailure(Test test, AssertionFailedError t) {
        log.error((Object)("[F] " + test.toString() + " : " + t.getMessage()));
    }

    public synchronized void startTest(Test test) {
        log.info((Object)("[START] " + test.toString()));
    }

    public void endTest(Test test) {
        log.info((Object)("[END] " + test.toString()));
    }

    public void runFailed(String message) {
        log.debug((Object)"--------------------------- runFailed() ---------------------------");
        this.errorMessage = message;
    }

    public void clearStatus() {
        log.debug((Object)"-------------------------- clearStatus() --------------------------");
        this.errorMessage = "";
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        if (this.session().objectForKey("ERXLog4JConfiguration.enabled") != null) {
            super.appendToResponse(r, c);
        } else {
            r.appendContentString("please use the ERXDirectAction log4jAction to login first!");
        }
    }
}

