/*
 * Decompiled with CFR 0.152.
 */
package er.wopaypal;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import er.wopaypal.PayPalEmailURLUTF8Encoder;
import er.wopaypal.PayPalSingleItemLinkBase;
import er.wopaypal.WOPayPal;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import java.util.Locale;

public class PayPalSingleItemHyperlink
extends PayPalSingleItemLinkBase {
    protected static String PAYPAL_CGI_COMMAND = "?cmd=_xclick";

    public PayPalSingleItemHyperlink(WOContext context) {
        super(context);
    }

    public boolean isStateless() {
        return true;
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public String payPalPurchaseHref() {
        StringBuffer sb = WOPayPal.baseUrl();
        sb.append(PayPalSingleItemLinkBase.PAYPAL_CGI_NAME);
        sb.append(PAYPAL_CGI_COMMAND);
        sb.append(this.payPalUrlParams());
        return sb.toString();
    }

    public String payPalUrlParams() {
        DecimalFormat currencyFormatter = new DecimalFormat("##0.00", new DecimalFormatSymbols(Locale.US));
        DecimalFormat taxFormatter = new DecimalFormat("##0.000", new DecimalFormatSymbols(Locale.US));
        StringBuffer sb = new StringBuffer();
        sb.append("&business=" + this.urlEncode(this.payPalBusinessName));
        if (this.userDefinableQuantity != null) {
            sb.append("&undefined_quantity=" + (this.userDefinableQuantity != false ? "1" : "0"));
        }
        if (this.itemName != null) {
            sb.append("&item_name=" + this.urlEncode(this.itemName));
        }
        if (this.itemNumber != null) {
            sb.append("&item_number=" + this.urlEncode(this.itemNumber));
        }
        if (this.custom != null) {
            sb.append("&custom=" + this.urlEncode(this.custom));
        }
        if (this.amount != null) {
            sb.append("&amount=" + currencyFormatter.format(Double.valueOf(this.amount)));
        }
        if (this.currencyCode != null) {
            sb.append("&currency_code=" + this.urlEncode(this.currencyCode));
        }
        if (this.collectShippingAddress != null) {
            sb.append("&no_shipping=" + (this.collectShippingAddress != false ? "0" : "1"));
        }
        if (this.allowCustomerNote != null) {
            sb.append("&no_note=" + (this.allowCustomerNote != false ? "0" : "1"));
        }
        if (this.logoURL != null) {
            sb.append("&image_url=" + PayPalEmailURLUTF8Encoder.encode(this.logoURL));
        }
        if (this.returnURL != null) {
            sb.append("&return=" + PayPalEmailURLUTF8Encoder.encode(this.returnURL));
        }
        if (this.cancelURL != null) {
            sb.append("&cancel_return=" + PayPalEmailURLUTF8Encoder.encode(this.cancelURL));
        }
        if (this.notifyURL != null) {
            sb.append("&notify_url=" + PayPalEmailURLUTF8Encoder.encode(this.notifyURL));
        } else if (this.useIPN != null && this.useIPN.booleanValue()) {
            sb.append("&notify_url=" + PayPalEmailURLUTF8Encoder.encode(this.defaultNotificationURL()));
        }
        if (this.tax_rate != null) {
            sb.append("&tax_rate=" + taxFormatter.format(Double.valueOf(this.tax_rate)));
        }
        return sb.toString();
    }

    private String urlEncode(String input) {
        String output = null;
        if (input != null) {
            try {
                output = URLEncoder.encode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                NSLog.err.appendln((Object)("Could not URL encode input string.  Error: " + uee.getMessage()));
            }
        }
        return output;
    }

    protected NSArray additionalBindingList() {
        NSMutableArray bindingArray = new NSMutableArray();
        bindingArray.addObjectsFromArray(new NSArray(new Object[0]));
        return bindingArray;
    }

    protected void pullBindings() {
        String key;
        Enumeration enumeration = this.baseBindingList().objectEnumerator();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.takeValueForKey(this.valueForBinding(key), key);
        }
        enumeration = this.additionalBindingList().objectEnumerator();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.takeValueForKey(this.valueForBinding(key), key);
        }
    }

    public void reset() {
        String key;
        Enumeration enumeration = this.baseBindingList().objectEnumerator();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.takeValueForKey(null, key);
        }
        enumeration = this.additionalBindingList().objectEnumerator();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.takeValueForKey(null, key);
        }
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        this.pullBindings();
        super.appendToResponse(r, c);
    }

    public void takeValuesFromRequest(WORequest r, WOContext c) {
        this.pullBindings();
        super.takeValuesFromRequest(r, c);
    }

    public WOActionResults invokeAction(WORequest r, WOContext c) {
        this.pullBindings();
        return super.invokeAction(r, c);
    }
}

