/*
 * Decompiled with CFR 0.152.
 */
package er.wopaypal;

import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.foundation.ERXProperties;
import er.wopaypal.PayPalNotificationListener;

public class WOPayPal {
    public static final String PAYPAL_URL_BASE = "http://www.paypal.com/";
    public static final String PAYPAL_SECURE_URL_BASE = "https://www.paypal.com/";
    public static final String PAYPAL_SANDBOX_URL_BASE = "https://www.sandbox.paypal.com/";
    public static final Class[] NotificationClassArray = new Class[]{NSNotification.class};
    private static NSMutableSet _retainer = new NSMutableSet();
    public static final String SANDBOX_MODE_PROP = "er.wopaypal.sandboxmode";
    private static boolean _isInitialized = false;

    public static void registerPayPalNotificationListenerObservers() {
        PayPalNotificationListener.Observer observer = PayPalNotificationListener.observer();
        _retainer.addObject((Object)observer);
        NSNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("handleDeniedPaymentNotification", NotificationClassArray), "DeniedPayPalPaymentReceivedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("handleFailedPaymentNotification", NotificationClassArray), "FailedPayPalPaymentReceivedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("handleInvalidPaymentNotification", NotificationClassArray), "InvalidPayPalPaymentReceivedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("handlePendingPaymentNotification", NotificationClassArray), "PendingPayPalPaymentReceivedNotification", null);
        NSNotificationCenter.defaultCenter().addObserver((Object)observer, new NSSelector("handleValidPaymentNotification", NotificationClassArray), "ValidPayPalPaymentReceivedNotification", null);
    }

    public static final boolean isSandboxMode() {
        return ERXProperties.booleanForKeyWithDefault((String)SANDBOX_MODE_PROP, (boolean)false);
    }

    public static final StringBuffer baseUrl() {
        StringBuffer sb = new StringBuffer();
        if (WOPayPal.isSandboxMode()) {
            sb.append(PAYPAL_SANDBOX_URL_BASE);
        } else {
            sb.append(PAYPAL_SECURE_URL_BASE);
        }
        return sb;
    }

    static {
        if (!_isInitialized) {
            try {
                WOPayPal.registerPayPalNotificationListenerObservers();
                _isInitialized = true;
            }
            catch (Exception e) {
                System.out.println("Caught exception: " + e.getMessage() + " stack: ");
                e.printStackTrace();
            }
        }
    }
}

