/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOObjectNotAvailableException;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOArrayDataSource;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EODataSource;
import com.webobjects.eocontrol.EODetailDataSource;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOKeyValueArchiver;
import com.webobjects.eocontrol.EOKeyValueArchiving;
import com.webobjects.eocontrol.EOKeyValueUnarchiver;
import com.webobjects.eocontrol.EOObjectStore;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class EODatabaseDataSource
extends EODataSource
implements Serializable,
EOKeyValueArchiving,
EOKeyValueArchiving.Awaking,
NSCoding {
    static final long serialVersionUID = 3664372796850160919L;
    protected EOEditingContext _editingContext;
    protected String _fetchSpecificationName;
    protected EOFetchSpecification _fetchSpecification;
    protected EOQualifier _auxiliaryQualifier;
    protected NSDictionary _bindings;
    protected boolean _flags_fetchEnabled;
    private EOEntity _entityCache;
    static int EODatabaseDataSourceVersion = 297;
    protected static final NSSelector _registeredDBContextSelector = new NSSelector("registeredDatabaseContextForModel", new Class[]{EOModel.class, EOEditingContext.class});
    private static final NSSelector _modelGroupSelector = new NSSelector("modelGroup", null);
    private static final NSSelector _entitySelector = new NSSelector("entity", null);
    private static final String SerializationFetchSpecificationNameFieldKey = "fetchSpecificationName";
    private static final String SerializationFetchSpecificationFieldKey = "fetchSpecification";
    private static final String SerializationQualifierFieldKey = "qualifier";
    private static final String SerializationEditingContextFieldKey = "editingContext";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("fetchSpecificationName", _NSUtilities._StringClass), new ObjectStreamField("fetchSpecification", EOFetchSpecification._CLASS), new ObjectStreamField("qualifier", EOQualifier._CLASS), new ObjectStreamField("editingContext", EOEditingContext._CLASS)};

    protected void _partialInitWithEditingContextEntityNameFetchSpecificationName(EOEditingContext anEditingContext, String anEntityName, String fetchSpecificationName) {
        this._flags_fetchEnabled = true;
        this._editingContext = anEditingContext;
        this._fetchSpecification = new EOFetchSpecification();
        this._fetchSpecification.setEntityName(anEntityName);
        this._fetchSpecificationName = fetchSpecificationName;
    }

    private void _setFetchSpecification(EOFetchSpecification fetchSpec) {
        this._fetchSpecification = fetchSpec;
    }

    public void _finishInitialization() {
        if (this._editingContext != null) {
            if (this.entity() == null) {
                throw new IllegalArgumentException("There is no model containing entity '" + this._fetchSpecification.entityName() + "' in the default model group. Unable to create EODatabaseDataSource.");
            }
            if (this._fetchSpecificationName != null) {
                this.setFetchSpecificationByName(this._fetchSpecificationName);
            }
            this.databaseContext();
        }
    }

    public EODatabaseDataSource(EOEditingContext anEditingContext, String anEntityName, String fetchSpecificationName) {
        this._partialInitWithEditingContextEntityNameFetchSpecificationName(anEditingContext, anEntityName, fetchSpecificationName);
        this._finishInitialization();
    }

    public EODatabaseDataSource(EOEditingContext anEditingContext, String anEntityName) {
        this(anEditingContext, anEntityName, null);
    }

    public Class classForCoder() {
        return this.getClass();
    }

    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObject((Object)this._fetchSpecification);
        coder.encodeObject((Object)this._auxiliaryQualifier);
        coder.encodeObject((Object)this._editingContext);
        coder.encodeObject((Object)this._fetchSpecificationName);
    }

    private static Object _decodeObject(EOEditingContext editingContext, String entityName, EOFetchSpecification fetchSpecification, String fetchSpecificationName, EOQualifier auxiliaryQualifier) {
        if (fetchSpecification != null) {
            entityName = fetchSpecification.entityName();
        }
        EODatabaseDataSource dataSource = new EODatabaseDataSource(editingContext, entityName);
        dataSource._partialInitWithEditingContextEntityNameFetchSpecificationName(editingContext, entityName, fetchSpecificationName);
        if (fetchSpecification != null && fetchSpecificationName == null) {
            dataSource.setFetchSpecification(fetchSpecification);
        }
        if (auxiliaryQualifier != null) {
            dataSource.setAuxiliaryQualifier(auxiliaryQualifier);
        }
        return dataSource;
    }

    public static Object decodeObject(NSCoder coder) {
        String aEntityName = null;
        EOFetchSpecification fetchSpec = (EOFetchSpecification)coder.decodeObject();
        EOQualifier auxQual = (EOQualifier)coder.decodeObject();
        EOEditingContext editingContext = (EOEditingContext)coder.decodeObject();
        String fetchSpecName = (String)coder.decodeObject();
        return EODatabaseDataSource._decodeObject(editingContext, aEntityName, fetchSpec, fetchSpecName, auxQual);
    }

    public void encodeWithKeyValueArchiver(EOKeyValueArchiver archiver) {
        archiver.encodeObject((Object)this._fetchSpecification, SerializationFetchSpecificationFieldKey);
        archiver.encodeObject((Object)this._auxiliaryQualifier, "auxiliaryQualifier");
        archiver.encodeReferenceToObject((Object)this._editingContext, SerializationEditingContextFieldKey);
        archiver.encodeObject((Object)this._fetchSpecificationName, SerializationFetchSpecificationNameFieldKey);
    }

    public static Object decodeWithKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        EOEditingContext editingContext = null;
        EOFetchSpecification fetchSpec = null;
        EOQualifier auxQual = null;
        String fetchSpecName = null;
        String aEntityName = (String)unarchiver.decodeObjectForKey("entityName");
        fetchSpec = (EOFetchSpecification)unarchiver.decodeObjectForKey(SerializationFetchSpecificationFieldKey);
        auxQual = (EOQualifier)unarchiver.decodeObjectForKey("auxiliaryQualifier");
        editingContext = (EOEditingContext)unarchiver.decodeObjectReferenceForKey(SerializationEditingContextFieldKey);
        fetchSpecName = (String)unarchiver.decodeObjectForKey(SerializationFetchSpecificationNameFieldKey);
        return EODatabaseDataSource._decodeObject(editingContext, aEntityName, fetchSpec, fetchSpecName, auxQual);
    }

    public void awakeFromKeyValueUnarchiver(EOKeyValueUnarchiver unarchiver) {
        this._finishInitialization();
    }

    public void awakeFromNib() {
        this._finishInitialization();
    }

    public void setEditingContext(EOEditingContext editingContext) {
        this._editingContext = editingContext;
    }

    public EOEditingContext editingContext() {
        return this._editingContext;
    }

    public Object createObject() {
        if (this.entity().isAbstractEntity()) {
            throw new IllegalArgumentException("It is impossible to create a concrete instance of an abstract entity like " + this.entity().name());
        }
        return super.createObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EOEntity entity() {
        if (this._entityCache == null) {
            EOObjectStore root = this.editingContext().rootObjectStore();
            root.lock();
            try {
                EOEntity cache;
                EOModelGroup group = null;
                if (root instanceof EOObjectStoreCoordinator) {
                    group = EOModelGroup.modelGroupForObjectStoreCoordinator((EOObjectStoreCoordinator)root);
                } else if (root instanceof EODatabaseContext) {
                    NSArray models = ((EODatabaseContext)root).database().models();
                    int count = models.count();
                    for (int i = 0; i < count && group == null; ++i) {
                        group = ((EOModel)models.objectAtIndex(i)).modelGroup();
                    }
                } else if (_modelGroupSelector.implementedByObject((Object)root)) {
                    group = (EOModelGroup)NSSelector._safeInvokeSelector((NSSelector)_modelGroupSelector, (Object)root, null);
                }
                if (group == null) {
                    group = EOModelGroup.defaultGroup();
                }
                this._entityCache = cache = group.entityNamed(this._fetchSpecification.entityName());
            }
            finally {
                root.unlock();
            }
        }
        return this._entityCache;
    }

    public EODatabaseContext databaseContext() {
        return (EODatabaseContext)((Object)NSSelector._safeInvokeSelector((NSSelector)_registeredDBContextSelector, (Object)EODatabaseContext.contextClassToRegister(), (Object[])new Object[]{this.entity().model(), this.editingContext()}));
    }

    public EOFetchSpecification fetchSpecification() {
        return this._fetchSpecification;
    }

    public void setFetchSpecification(EOFetchSpecification fetchSpec) {
        this._fetchSpecificationName = null;
        this._entityCache = null;
        this._fetchSpecification = fetchSpec;
    }

    public void setFetchSpecificationByName(String fetchSpecificationName) {
        String newFetchSpecName = fetchSpecificationName;
        EOFetchSpecification newFetchSpec = this.entity().fetchSpecificationNamed(newFetchSpecName);
        if (newFetchSpec == null) {
            throw new EOObjectNotAvailableException("setFetchSpecificationByName -- " + this.getClass().getName() + ": Failed to find the fetch specification named " + fetchSpecificationName + " in the entity named " + this._fetchSpecification.entityName() + ".");
        }
        this._fetchSpecification = newFetchSpec;
        this._fetchSpecificationName = newFetchSpecName;
        this._entityCache = null;
    }

    public String fetchSpecificationName() {
        return this._fetchSpecificationName;
    }

    public void setAuxiliaryQualifier(EOQualifier newQualifier) {
        this._auxiliaryQualifier = newQualifier;
    }

    public EOQualifier auxiliaryQualifier() {
        return this._auxiliaryQualifier;
    }

    public NSArray qualifierBindingKeys() {
        NSArray mainBindings = this._fetchSpecification.qualifier().bindingKeys();
        NSArray auxiliaryBindings = this._auxiliaryQualifier.bindingKeys();
        if (mainBindings.count() != 0 && auxiliaryBindings.count() != 0) {
            NSMutableSet allBindings = new NSMutableSet(mainBindings);
            allBindings.unionSet(new NSSet(auxiliaryBindings));
            NSArray allBindingsArray = allBindings.allObjects();
            return allBindingsArray;
        }
        if (mainBindings.count() != 0) {
            return mainBindings;
        }
        if (auxiliaryBindings.count() != 0) {
            return auxiliaryBindings;
        }
        return NSArray.EmptyArray;
    }

    public void setQualifierBindings(NSDictionary bindings) {
        this._bindings = bindings;
    }

    public NSDictionary qualifierBindings() {
        return this._bindings;
    }

    public void setFetchEnabled(boolean yn) {
        this._flags_fetchEnabled = yn;
    }

    public boolean isFetchEnabled() {
        return this._flags_fetchEnabled;
    }

    public EOClassDescription classDescriptionForObjects() {
        return this.entity().classDescriptionForInstances();
    }

    public EOFetchSpecification fetchSpecificationForFetch() {
        EOQualifier qualifier;
        if (this._fetchSpecification == null) {
            return null;
        }
        EOQualifier newQualifier = null;
        EOQualifier newAuxiliaryQualifier = null;
        if (this._auxiliaryQualifier != null) {
            newAuxiliaryQualifier = this._bindings != null ? this._auxiliaryQualifier.qualifierWithBindings(this._bindings, this._fetchSpecification.requiresAllQualifierBindingVariables()) : this._auxiliaryQualifier;
        }
        if ((qualifier = this._fetchSpecification.qualifier()) != null) {
            newQualifier = this._bindings != null ? qualifier.qualifierWithBindings(this._bindings, this._fetchSpecification.requiresAllQualifierBindingVariables()) : qualifier;
        }
        if (newQualifier != null || newAuxiliaryQualifier != null || newQualifier != qualifier) {
            EOQualifier combinedQualifier;
            if (newQualifier != null && newAuxiliaryQualifier != null) {
                combinedQualifier = new EOAndQualifier(new NSArray(new Object[]{newQualifier, newAuxiliaryQualifier}));
            } else if (newQualifier != qualifier) {
                combinedQualifier = newQualifier;
            } else if (newAuxiliaryQualifier != null) {
                combinedQualifier = newAuxiliaryQualifier;
            } else {
                return this._fetchSpecification;
            }
            EOFetchSpecification newFetchSpec = (EOFetchSpecification)this._fetchSpecification.clone();
            newFetchSpec.setQualifier(combinedQualifier);
            return newFetchSpec;
        }
        return this._fetchSpecification;
    }

    public NSArray fetchObjects() {
        if (!this.isFetchEnabled()) {
            return NSArray.EmptyArray;
        }
        EOFetchSpecification specForFetch = this.fetchSpecificationForFetch();
        if (specForFetch == null) {
            return null;
        }
        EOEditingContext editingContext = this.editingContext();
        return editingContext.objectsWithFetchSpecification(specForFetch, editingContext);
    }

    public void insertObject(Object object) {
    }

    public void deleteObject(Object object) {
        this.editingContext().deleteObject((EOEnterpriseObject)object);
    }

    public EODataSource dataSourceQualifiedByKey(String key) {
        return new EODetailDataSource((EODataSource)this, key);
    }

    public void qualifyWithRelationshipKey(String key, Object sourceObject) {
        this.setFetchEnabled(false);
        if (sourceObject == null) {
            return;
        }
        EOQualifier qualifier = EODatabaseDataSource._qualifierForRelationshipKey(key, (EOEnterpriseObject)sourceObject);
        this.fetchSpecification().setQualifier(qualifier);
        this.setFetchEnabled(qualifier != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EOQualifier _qualifierForRelationshipKey(String key, EOEnterpriseObject source) {
        EOQualifier newQualifier = null;
        EORelationship relationship = null;
        NSDictionary dbSnapshot = null;
        EOEditingContext sourceEC = source.editingContext();
        EOModelGroup modelGroup = EOUtilities.modelGroup(sourceEC);
        EOEntity sourceEntity = modelGroup.entityNamed(source.entityName());
        if (sourceEntity == null) {
            throw new IllegalStateException("qualifyWithRelationshipKey: EODatabaseDataSource unable to find entity for " + source.getClass().getName() + " " + source + " in " + modelGroup.getClass().getName() + " " + modelGroup);
        }
        relationship = sourceEntity.relationshipNamed(key);
        if (relationship == null) {
            throw new IllegalStateException("qualifyWithRelationshipKey: EODatabaseDataSource entity " + sourceEntity.name() + " has no relationship named " + key);
        }
        EOObjectStore sourceRootObjectStore = sourceEC.rootObjectStore();
        sourceRootObjectStore.lock();
        try {
            Object actualObjectStore = sourceRootObjectStore instanceof EOObjectStoreCoordinator ? ((EOObjectStoreCoordinator)sourceRootObjectStore).objectStoreForObject(source) : sourceRootObjectStore;
            dbSnapshot = ((EODatabaseContext)((Object)actualObjectStore)).snapshotForGlobalID(sourceEC.globalIDForObject(source));
            if (dbSnapshot != null && (newQualifier = relationship.qualifierWithSourceRow(dbSnapshot)) == null) {
                throw new IllegalStateException("qualifyWithRelationshipKey: EODatabaseDataSource unable to construct qualifier for relationship " + key + " in entity " + sourceEntity.name() + " with database snapshot: " + dbSnapshot);
            }
            EOQualifier eOQualifier = newQualifier;
            return eOQualifier;
        }
        finally {
            sourceRootObjectStore.unlock();
        }
    }

    public void setParentDataSourceRelationshipKey(EODataSource parent, String key) {
        EOEntity masterEntity = null;
        Class<?> parentClass = parent.getClass();
        if (parent instanceof EODatabaseDataSource) {
            masterEntity = ((EODatabaseDataSource)parent).entity();
        } else if (parentClass == EODetailDataSource.class || parentClass == EOArrayDataSource.class) {
            masterEntity = null;
        } else {
            NSSelector selector = _entitySelector;
            if (selector.implementedByObject((Object)parent)) {
                masterEntity = (EOEntity)NSSelector._safeInvokeSelector((NSSelector)selector, (Object)parent, null);
            }
        }
        if (masterEntity != null) {
            this.fetchSpecification().setEntityName(masterEntity.relationshipNamed(key).destinationEntity().name());
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationFetchSpecificationNameFieldKey, this._fetchSpecificationName);
        fields.put(SerializationFetchSpecificationFieldKey, this._fetchSpecification);
        fields.put(SerializationQualifierFieldKey, this._auxiliaryQualifier);
        fields.put(SerializationEditingContextFieldKey, this._editingContext);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        String fetchSpecificationName = (String)fields.get(SerializationFetchSpecificationNameFieldKey, null);
        EOFetchSpecification fetchSpec = (EOFetchSpecification)fields.get(SerializationFetchSpecificationFieldKey, null);
        EOQualifier qualifier = (EOQualifier)fields.get(SerializationQualifierFieldKey, null);
        EOEditingContext anEditingContext = (EOEditingContext)fields.get(SerializationEditingContextFieldKey, null);
        String entityName = fetchSpec.entityName();
        this._partialInitWithEditingContextEntityNameFetchSpecificationName(anEditingContext, entityName, fetchSpecificationName);
        if (fetchSpec != null) {
            this.setFetchSpecification(fetchSpec);
        }
        if (qualifier != null) {
            this.setAuxiliaryQualifier(qualifier);
        }
        this.databaseContext();
    }
}

