/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.eoaccess;

import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;

public class EODatabaseOperation {
    protected int _databaseOperator;
    protected NSMutableDictionary _newRow;
    protected EOGlobalID _globalID;
    protected EOEntity _entity;
    protected NSMutableArray _adaptorOps;
    protected Object _object;
    protected NSDictionary _dbSnapshot;
    protected NSMutableDictionary _toManySnapshots;
    public static final int DatabaseNothingOperator = 0;
    public static final int DatabaseInsertOperator = 1;
    public static final int DatabaseUpdateOperator = 2;
    public static final int DatabaseDeleteOperator = 3;
    public static final int AdaptorLockOperator = 0;
    public static final int AdaptorInsertOperator = 1;
    public static final int AdaptorUpdateOperator = 2;
    public static final int AdaptorDeleteOperator = 3;
    public static final int AdaptorStoredProcedureOperator = 4;

    public EODatabaseOperation(EOGlobalID globalID, Object object, EOEntity entity) {
        this._object = object;
        this._entity = entity;
        this._globalID = globalID;
    }

    public NSDictionary dbSnapshot() {
        return this._dbSnapshot;
    }

    public void setDBSnapshot(NSDictionary dbSnapshot) {
        this._dbSnapshot = dbSnapshot;
    }

    public NSMutableDictionary newRow() {
        return this._newRow;
    }

    public void setNewRow(NSMutableDictionary newRow) {
        this._newRow = newRow;
    }

    public EOGlobalID globalID() {
        return this._globalID;
    }

    public Object object() {
        return this._object;
    }

    public EOEntity entity() {
        return this._entity;
    }

    public int databaseOperator() {
        return this._databaseOperator;
    }

    public void setDatabaseOperator(int databaseOperator) {
        if (this._databaseOperator == 0) {
            this._databaseOperator = databaseOperator;
            return;
        }
        switch (this._databaseOperator) {
            case 2: {
                this._databaseOperator = databaseOperator;
                break;
            }
            case 1: {
                if (databaseOperator != 3) break;
                throw new IllegalStateException("setDatabaseOperator: " + this.getClass().getName() + " " + this + " -- illegal attempt to set change databaseOperator from insert to delete");
            }
            case 3: {
                if (databaseOperator != 1) break;
                throw new IllegalStateException("setDatabaseOperator: " + this.getClass().getName() + " " + this + " -- illegal attempt to set change databaseOperator from delete to insert");
            }
            case 0: {
                this._databaseOperator = databaseOperator;
            }
        }
    }

    public NSDictionary rowDiffs() {
        NSMutableDictionary result = null;
        Enumeration keys = this._newRow.keyEnumerator();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object o1 = this._newRow.objectForKey((Object)key);
            Object o2 = this._dbSnapshot.objectForKey((Object)key);
            EORelationship rel = this._entity.anyRelationshipNamed(key);
            boolean isEquivalent = false;
            if (rel == null) {
                if (o1 == o2 || o1.equals(o2)) {
                    isEquivalent = true;
                }
            } else if (!rel.isToMany()) {
                if (o1 == o2) {
                    isEquivalent = true;
                }
            } else if (o1 == o2 || o1.equals(o2) || o1 == ((NSArray)o2).immutableClone()) {
                isEquivalent = true;
            }
            if (isEquivalent) continue;
            if (result == null) {
                result = new NSMutableDictionary();
            }
            result.setObjectForKey(o1, (Object)key);
        }
        return result;
    }

    public NSDictionary rowDiffsForAttributes(NSArray atts) {
        NSMutableDictionary diffs = null;
        for (int i = atts.count() - 1; i >= 0; --i) {
            EOAttribute att = (EOAttribute)atts.objectAtIndex(i);
            String key = this._entity.snapshotKeyForAttributeName(att.name());
            Object o1 = this._newRow.objectForKey((Object)key);
            Object o2 = this._dbSnapshot.objectForKey((Object)key);
            if (o1 == null || o2 == null) {
                throw new IllegalStateException("rowDiffsForAttributes: snapshot in " + this.getClass().getName() + " " + this + " does not contain value for attribute named " + att.name() + " with snapshot key: " + key);
            }
            if (o1.equals(o2)) continue;
            if (diffs == null) {
                diffs = new NSMutableDictionary();
            }
            diffs.setObjectForKey(o1, (Object)key);
        }
        return diffs == null ? NSDictionary.EmptyDictionary : diffs;
    }

    public NSDictionary primaryKeyDiffs() {
        if (this._databaseOperator != 2) {
            return NSDictionary.EmptyDictionary;
        }
        return this.rowDiffsForAttributes(this._entity.primaryKeyAttributes());
    }

    public NSArray adaptorOperations() {
        return this._adaptorOps == null ? NSArray.EmptyArray : this._adaptorOps;
    }

    public void addAdaptorOperation(EOAdaptorOperation adaptorOp) {
        if (this._adaptorOps == null) {
            this._adaptorOps = new NSMutableArray(64);
        }
        this._adaptorOps.addObject((Object)adaptorOp);
    }

    public void removeAdaptorOperation(EOAdaptorOperation adaptorOp) {
        this._adaptorOps.removeObject((Object)adaptorOp);
        if (this._adaptorOps.count() == 0) {
            this._adaptorOps = null;
        }
    }

    public String toString() {
        NSMutableDictionary dict = new NSMutableDictionary(8);
        switch (this._databaseOperator) {
            case 0: {
                dict.setObjectForKey((Object)"EODatabaseNothingOperator", (Object)"_databaseOperator");
                break;
            }
            case 1: {
                dict.setObjectForKey((Object)"EODatabaseInsertOperator", (Object)"_databaseOperator");
                break;
            }
            case 3: {
                dict.setObjectForKey((Object)"EODatabaseDeleteOperator", (Object)"_databaseOperator");
                break;
            }
            case 2: {
                dict.setObjectForKey((Object)"EODatabaseUpdateOperator", (Object)"_databaseOperator");
                break;
            }
            default: {
                dict.setObjectForKey((Object)"<unrecognized value>", (Object)"_databaseOperator");
            }
        }
        if (this._newRow != null) {
            dict.setObjectForKey((Object)this._newRow, (Object)"_newRow");
        }
        if (this._dbSnapshot != null) {
            dict.setObjectForKey((Object)this._dbSnapshot, (Object)"_dbSnapshot");
        }
        if (this._globalID != null) {
            dict.setObjectForKey((Object)this._globalID, (Object)"_globalID");
        }
        if (this._entity != null) {
            dict.setObjectForKey((Object)this._entity.name(), (Object)"_entity");
        }
        if (this._adaptorOps != null) {
            dict.setObjectForKey((Object)this._adaptorOps, (Object)"_adaptorOps");
        }
        if (this._object != null) {
            dict.setObjectForKey((Object)this._object.toString(), (Object)"_object");
        }
        String string = dict.toString();
        return string;
    }

    public void recordToManySnapshot(NSArray gids, String name) {
        if (this._toManySnapshots == null) {
            this._toManySnapshots = new NSMutableDictionary();
        }
        if (gids == null) {
            this._toManySnapshots.setObjectForKey((Object)NSKeyValueCoding.NullValue, (Object)name);
        } else {
            this._toManySnapshots.setObjectForKey((Object)gids, (Object)name);
        }
    }

    public NSDictionary toManySnapshots() {
        return this._toManySnapshots;
    }
}

