/*
 * Decompiled with CFR 0.152.
 */
package er.googlechart.components;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODynamicElement;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.ajax.AjaxUtils;
import er.extensions.foundation.ERXMutableURL;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.googlechart.util.GCAbstractEncoding;
import er.googlechart.util.GCEncoding;
import er.googlechart.util.GCTextEncoding;
import java.net.MalformedURLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GCAbstractChart
extends WODynamicElement {
    protected WOAssociation _data;
    protected WOAssociation _size;
    protected WOAssociation _width;
    protected WOAssociation _height;
    protected WOAssociation _colors;
    protected WOAssociation _title;
    protected WOAssociation _titleColor;
    protected WOAssociation _titleSize;
    protected WOAssociation _backgroundStyle;
    protected WOAssociation _background;
    protected WOAssociation _chartBackgroundStyle;
    protected WOAssociation _chartBackground;
    protected WOAssociation _transparency;
    protected WOAssociation _legend;
    protected WOAssociation _labeledAxes;
    protected WOAssociation _axisLabels;
    protected WOAssociation _custom;
    protected WOAssociation _id;
    protected WOAssociation _class;
    protected WOAssociation _alt;
    protected WOAssociation _encoding;
    protected WOAssociation _normalize;
    protected WOAssociation _maxValue;
    protected WOAssociation _scaling;
    protected WOAssociation _fillArea;
    protected WOAssociation _lineStyles;
    protected WOAssociation _rangeMarkers;
    protected WOAssociation _shapeMarkers;
    protected WOAssociation _gridLines;
    protected WOAssociation _gridXStep;
    protected WOAssociation _gridYStep;
    protected WOAssociation _gridLineSize;
    protected WOAssociation _gridBlankSize;

    public GCAbstractChart(String name, NSDictionary associations, WOElement element) {
        super(name, associations, element);
        this._data = (WOAssociation)associations.objectForKey((Object)"data");
        this._size = (WOAssociation)associations.objectForKey((Object)"size");
        this._width = (WOAssociation)associations.objectForKey((Object)"width");
        this._height = (WOAssociation)associations.objectForKey((Object)"height");
        this._colors = (WOAssociation)associations.objectForKey((Object)"colors");
        this._title = (WOAssociation)associations.objectForKey((Object)"title");
        this._titleColor = (WOAssociation)associations.objectForKey((Object)"titleColor");
        this._titleSize = (WOAssociation)associations.objectForKey((Object)"titleSize");
        this._backgroundStyle = (WOAssociation)associations.objectForKey((Object)"backgroundStyle");
        this._background = (WOAssociation)associations.objectForKey((Object)"background");
        this._chartBackgroundStyle = (WOAssociation)associations.objectForKey((Object)"chartBackgroundStyle");
        this._chartBackground = (WOAssociation)associations.objectForKey((Object)"chartBackground");
        this._transparency = (WOAssociation)associations.objectForKey((Object)"transparency");
        this._legend = (WOAssociation)associations.objectForKey((Object)"legend");
        this._labeledAxes = (WOAssociation)associations.objectForKey((Object)"labeledAxes");
        this._axisLabels = (WOAssociation)associations.objectForKey((Object)"axisLabels");
        this._custom = (WOAssociation)associations.objectForKey((Object)"custom");
        this._id = (WOAssociation)associations.objectForKey((Object)"id");
        this._class = (WOAssociation)associations.objectForKey((Object)"class");
        this._alt = (WOAssociation)associations.objectForKey((Object)"alt");
        this._encoding = (WOAssociation)associations.objectForKey((Object)"encoding");
        this._normalize = (WOAssociation)associations.objectForKey((Object)"normalize");
        this._maxValue = (WOAssociation)associations.objectForKey((Object)"maxValue");
        this._scaling = (WOAssociation)associations.objectForKey((Object)"scaling");
        this._fillArea = (WOAssociation)associations.objectForKey((Object)"fillArea");
        this._lineStyles = (WOAssociation)associations.objectForKey((Object)"lineStyles");
        this._rangeMarkers = (WOAssociation)associations.objectForKey((Object)"rangeMarkers");
        this._shapeMarkers = (WOAssociation)associations.objectForKey((Object)"shapeMarkers");
        this._gridLines = (WOAssociation)associations.objectForKey((Object)"gridLines");
        this._gridXStep = (WOAssociation)associations.objectForKey((Object)"gridXStep");
        this._gridYStep = (WOAssociation)associations.objectForKey((Object)"gridYStep");
        this._gridLineSize = (WOAssociation)associations.objectForKey((Object)"gridLineSize");
        this._gridBlankSize = (WOAssociation)associations.objectForKey((Object)"gridBlankSize");
    }

    protected void addQueryParameters(ERXMutableURL chartUrl, WOResponse response, WOContext context) {
    }

    protected void checkData(List<List<Number>> data, WOResponse response, WOContext context) {
    }

    protected Number maxValue(WOResponse response, WOContext context) {
        return this._maxValue == null ? (Number)null : (Number)GCEncoding.numberFromObject(this._maxValue.valueInComponent(context.component()));
    }

    protected boolean normalize(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        boolean normalize = true;
        if (this._normalize == null) {
            if (this._maxValue != null) {
                Object maxValue = this._maxValue.valueInComponent(component);
                if (maxValue instanceof Boolean) {
                    normalize = (Boolean)maxValue;
                } else if (maxValue == null) {
                    normalize = true;
                }
            }
        } else {
            normalize = this._normalize.booleanValueInComponent(component);
        }
        return normalize;
    }

    protected Object scaling(WOResponse response, WOContext context) {
        Object scaling = this._scaling == null ? null : this._scaling.valueInComponent(context.component());
        return scaling;
    }

    protected GCAbstractEncoding encoding(List<List<Number>> data, WOResponse response, WOContext context) {
        GCAbstractEncoding encoding;
        if (this._encoding != null) {
            String encodingName = (String)this._encoding.valueInComponent(context.component());
            try {
                encoding = Class.forName("GC" + ERXStringUtilities.capitalize((String)encodingName) + "Encoding").asSubclass(GCAbstractEncoding.class).newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create the encoding named '" + encodingName + "'.");
            }
        } else {
            Number maxValue;
            Object scaling = this.scaling(response, context);
            encoding = scaling instanceof Boolean && (Boolean)scaling != false || scaling != null ? new GCTextEncoding() : ((maxValue = this.maxValue(response, context)) != null ? GCEncoding.recommendedEncoding(maxValue, data) : GCEncoding.recommendedEncoding(this.normalize(response, context), data));
        }
        return encoding;
    }

    protected String encode(List<List<Number>> data, WOResponse response, WOContext context) {
        GCAbstractEncoding encoding = this.encoding(data, response, context);
        Number maxValue = this.maxValue(response, context);
        String encodedValue = maxValue != null ? encoding.encode(maxValue, data) : encoding.encode(this.normalize(response, context), data);
        return encodedValue;
    }

    protected String styleKey(String styleName) {
        String styleKey;
        if ("solid".equals(styleName)) {
            styleKey = "s";
        } else if ("stripes".equals(styleName)) {
            styleKey = "ls";
        } else if ("gradient".equals(styleName)) {
            styleKey = "lg";
        } else {
            throw new IllegalArgumentException("Unknown style name '" + styleName + "'.");
        }
        return styleKey;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        String custom;
        NSArray axisLabels;
        NSArray labeledAxes;
        NSArray legend;
        String title;
        Object scaling;
        ERXMutableURL chartUrl = new ERXMutableURL();
        chartUrl.setProtocol("http");
        chartUrl.setHost("chart.apis.google.com");
        chartUrl.setPath("/chart");
        WOComponent component = context.component();
        int width = 300;
        int height = 200;
        if (this._size != null) {
            String sizeStr = (String)this._size.valueInComponent(component);
            if (sizeStr != null) {
                String[] sizeStrs = sizeStr.split("x");
                width = Integer.parseInt(sizeStrs[0]);
                height = Integer.parseInt(sizeStrs[1]);
            }
        } else {
            if (this._width != null) {
                width = ERXValueUtilities.intValueWithDefault((Object)this._width.valueInComponent(component), (int)width);
            }
            if (this._height != null) {
                height = ERXValueUtilities.intValueWithDefault((Object)this._height.valueInComponent(component), (int)height);
            }
        }
        chartUrl.setQueryParameter("chs", width + "x" + height);
        NSArray colors = AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._colors);
        if (colors != null) {
            chartUrl.setQueryParameter("chco", colors.componentsJoinedByString(","));
        }
        List<List<Number>> data = null;
        if (this._data != null) {
            Object dataValue = this._data.valueInComponent(component);
            if (dataValue instanceof String && ((String)dataValue).length() >= 2 && ((String)dataValue).charAt(1) == ':') {
                chartUrl.setQueryParameter("chd", (String)dataValue);
            } else {
                data = GCEncoding.convertToNumberLists((List)AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._data));
                chartUrl.setQueryParameter("chd", this.encode(data, response, context));
            }
        }
        if ((scaling = this.scaling(response, context)) instanceof Boolean && ((Boolean)scaling).booleanValue()) {
            if (data != null) {
                NSMutableArray scaleNumbers = new NSMutableArray();
                for (List<Number> innerList : data) {
                    Float minValue = Float.valueOf(GCEncoding.minValueInList(innerList));
                    scaleNumbers.addObject((Object)String.format("%1$.1f", minValue));
                    Number maxValue = this.maxValue(response, context);
                    if (maxValue == null) {
                        maxValue = Float.valueOf(GCEncoding.minValueInList(innerList));
                    }
                    scaleNumbers.addObject((Object)String.format("%1$.1f", maxValue));
                }
                chartUrl.setQueryParameter("chds", scaleNumbers.componentsJoinedByString(","));
            }
        } else {
            chartUrl.setQueryParameter("chds", (String)scaling);
        }
        if (this._title != null && (title = (String)this._title.valueInComponent(component)) != null) {
            chartUrl.setQueryParameter("chtt", title);
        }
        if (this._titleColor != null || this._titleSize != null) {
            String titleColor = "454545";
            if (this._titleColor != null) {
                titleColor = (String)this._titleColor.valueInComponent(component);
            }
            if (this._titleSize != null) {
                Object titleSize = this._titleSize.valueInComponent(component);
                chartUrl.setQueryParameter("chts", titleColor + "," + titleSize);
            } else {
                chartUrl.setQueryParameter("chts", titleColor);
            }
        }
        if (this._lineStyles != null) {
            chartUrl.setQueryParameter("chls", (String)this._lineStyles.valueInComponent(component));
        }
        if (this._fillArea != null) {
            chartUrl.setQueryParameter("chm", (String)this._fillArea.valueInComponent(component));
        }
        if (this._rangeMarkers != null) {
            chartUrl.setQueryParameter("chm", (String)this._rangeMarkers.valueInComponent(component));
        }
        if (this._shapeMarkers != null) {
            chartUrl.setQueryParameter("chm", (String)this._shapeMarkers.valueInComponent(component));
        }
        if (this._gridLines != null) {
            chartUrl.setQueryParameter("chg", (String)this._gridLines.valueInComponent(component));
        } else if (this._gridXStep != null || this._gridYStep != null || this._gridLineSize != null || this._gridBlankSize != null) {
            StringBuffer chg = new StringBuffer();
            if (this._gridXStep != null && this._gridYStep != null) {
                chg.append(this._gridXStep.valueInComponent(component));
                chg.append(",");
                chg.append(this._gridYStep.valueInComponent(component));
            }
            if (this._gridLineSize != null || this._gridBlankSize != null) {
                if (chg.length() == 0) {
                    chg.append("20,50");
                }
                if (this._gridLineSize != null) {
                    chg.append(",");
                    chg.append(this._gridLineSize.valueInComponent(component));
                }
                if (this._gridBlankSize != null) {
                    if (this._gridLineSize == null) {
                        chg.append(",5");
                    }
                    chg.append(",");
                    chg.append(this._gridBlankSize.valueInComponent(component));
                }
            }
            chartUrl.setQueryParameter("chg", chg.toString());
        }
        StringBuffer fill = new StringBuffer();
        String backgroundStyle = "solid";
        if (this._backgroundStyle != null) {
            backgroundStyle = (String)this._backgroundStyle.valueInComponent(component);
        }
        if (this._background != null) {
            fill.append("bg,");
            fill.append(this.styleKey(backgroundStyle));
            fill.append(",");
            fill.append(this._background.valueInComponent(component));
        }
        String chartBackgroundStyle = "solid";
        if (this._chartBackgroundStyle != null) {
            chartBackgroundStyle = (String)this._chartBackgroundStyle.valueInComponent(component);
        }
        if (this._chartBackground != null) {
            if (fill.length() > 0) {
                fill.append("|");
            }
            fill.append("c,");
            fill.append(this.styleKey(chartBackgroundStyle));
            fill.append(",");
            fill.append(this._chartBackground.valueInComponent(component));
        }
        if ((this._chartBackground != null || this._transparency != null) && this._transparency != null) {
            if (fill.length() > 0) {
                fill.append("|");
            }
            fill.append("a,s,");
            fill.append(this._transparency.valueInComponent(component));
        }
        if (fill.length() > 0) {
            chartUrl.setQueryParameter("chf", fill.toString());
        }
        if ((legend = AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._legend)) != null) {
            chartUrl.setQueryParameter("chdl", legend.componentsJoinedByString("|"));
        }
        if ((labeledAxes = AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._labeledAxes)) != null) {
            chartUrl.setQueryParameter("chxt", labeledAxes.componentsJoinedByString(","));
        }
        if ((axisLabels = AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._axisLabels)) != null) {
            StringBuffer axisLabelsStr = new StringBuffer();
            for (int i = 0; i < axisLabels.count(); ++i) {
                Object singleAxisLabels = axisLabels.objectAtIndex(i);
                if (i > 0) {
                    axisLabelsStr.append("|");
                }
                axisLabelsStr.append(i + ":|");
                if (singleAxisLabels instanceof Object[]) {
                    axisLabelsStr.append(new NSArray((Object[])singleAxisLabels).componentsJoinedByString("|"));
                    continue;
                }
                axisLabelsStr.append(singleAxisLabels);
            }
            chartUrl.setQueryParameter("chxl", axisLabelsStr.toString());
        }
        if (this._custom != null && (custom = (String)this._custom.valueInComponent(component)) != null) {
            try {
                chartUrl.addQueryParameters(custom);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to add the query parameters '" + custom + "'.", e);
            }
        }
        this.addQueryParameters(chartUrl, response, context);
        response.appendContentString("<img");
        if (this._id != null) {
            response._appendTagAttributeAndValue("id", (String)this._id.valueInComponent(component), true);
        }
        if (this._class != null) {
            response._appendTagAttributeAndValue("class", (String)this._class.valueInComponent(component), true);
        }
        if (this._alt != null) {
            response._appendTagAttributeAndValue("alt", (String)this._alt.valueInComponent(component), true);
        }
        response._appendTagAttributeAndValue("src", chartUrl.toExternalForm(), false);
        response._appendTagAttributeAndValue("width", String.valueOf(width), false);
        response._appendTagAttributeAndValue("height", String.valueOf(height), false);
        response.appendContentString("/>");
    }
}

