/*
 * Decompiled with CFR 0.152.
 */
package er.googlechart.util;

import com.webobjects.foundation.NSKeyValueCoding;
import er.googlechart.util.GCAbstractEncoding;
import er.googlechart.util.GCExtendedEncoding;
import er.googlechart.util.GCSimpleEncoding;
import er.googlechart.util.GCTextEncoding;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GCEncoding {
    private static GCAbstractEncoding[] ENCODINGS = new GCAbstractEncoding[]{new GCSimpleEncoding(), new GCExtendedEncoding(), new GCTextEncoding()};

    public static GCAbstractEncoding recommendedEncoding(boolean normalize, List<List<Number>> dataSets) {
        for (GCAbstractEncoding encoding : ENCODINGS) {
            if (!encoding.canEncode(normalize, dataSets)) continue;
            return encoding;
        }
        throw new IllegalArgumentException("There was no encoder capable of encoding the given data sets.");
    }

    public static GCAbstractEncoding recommendedEncoding(Number maxValue, List<List<Number>> dataSets) {
        for (GCAbstractEncoding encoding : ENCODINGS) {
            if (!encoding.canEncode(maxValue, dataSets)) continue;
            return encoding;
        }
        throw new IllegalArgumentException("There was no encoder capable of encoding the given data sets.");
    }

    protected static List<Number> _convertToNumberList(List dataSet) {
        LinkedList<Number> numbers = new LinkedList<Number>();
        for (Object datum : dataSet) {
            Number number = GCEncoding.numberFromObject(datum);
            numbers.add(number);
        }
        return numbers;
    }

    public static List<List<Number>> convertToNumberLists(List dataSets) {
        LinkedList outerList;
        if (dataSets == null || !dataSets.isEmpty() && dataSets.get(0) instanceof List) {
            outerList = dataSets;
        } else if (!dataSets.isEmpty() && dataSets.get(0).getClass().isArray()) {
            outerList = new LinkedList();
            for (Object e : dataSets) {
                Object[] objectArray = (Object[])e;
                LinkedList<Object> innerList = new LinkedList<Object>();
                for (Object innerObj : objectArray) {
                    innerList.add(innerObj);
                }
                outerList.add(innerList);
            }
        } else {
            outerList = new LinkedList();
            outerList.add(dataSets);
        }
        LinkedList<List<Number>> numberLists = new LinkedList<List<Number>>();
        if (outerList != null) {
            for (List list : outerList) {
                numberLists.add(GCEncoding._convertToNumberList(list));
            }
        }
        return numberLists;
    }

    public static Number numberFromObject(Object datum) {
        Number number;
        if (datum instanceof Number) {
            number = (Number)datum;
        } else if (datum instanceof String) {
            number = Integer.parseInt((String)datum);
        } else if (datum instanceof Boolean) {
            number = null;
        } else if (datum instanceof NSKeyValueCoding.Null) {
            number = null;
        } else {
            throw new IllegalArgumentException("Unable to convert " + datum + " to a number.");
        }
        return number;
    }

    public static boolean hasDecimalInList(List<Number> dataSet) {
        boolean hasDecimals = false;
        if (dataSet != null) {
            for (Number datum : dataSet) {
                if (!(datum instanceof Float) && !(datum instanceof Double)) continue;
                hasDecimals = true;
                break;
            }
        }
        return hasDecimals;
    }

    public static boolean hasDecimalInLists(List<List<Number>> dataSets) {
        List<Number> dataSet;
        boolean hasDecimals = false;
        Iterator<List<Number>> i$ = dataSets.iterator();
        while (i$.hasNext() && !(hasDecimals = GCEncoding.hasDecimalInList(dataSet = i$.next()))) {
        }
        return hasDecimals;
    }

    public static float maxValueInList(List<Number> dataSet) {
        float maxValue = 0.0f;
        if (dataSet != null) {
            for (Number datum : dataSet) {
                if (datum == null) continue;
                maxValue = Math.max(maxValue, datum.floatValue());
            }
        }
        return maxValue;
    }

    public static float maxValueInLists(List<List<Number>> dataSets) {
        float maxValue = 0.0f;
        for (List<Number> dataSet : dataSets) {
            maxValue = Math.max(maxValue, GCEncoding.maxValueInList(dataSet));
        }
        return maxValue;
    }

    public static float minValueInList(List<Number> dataSet) {
        float minValue = 0.0f;
        if (dataSet != null) {
            for (Number datum : dataSet) {
                if (datum == null) continue;
                minValue = Math.min(minValue, datum.floatValue());
            }
        }
        return minValue;
    }

    public static float minValueInLists(List<List<Number>> dataSets) {
        float minValue = 0.0f;
        for (List<Number> dataSet : dataSets) {
            minValue = Math.max(minValue, GCEncoding.minValueInList(dataSet));
        }
        return minValue;
    }
}

