/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects._ideservices;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _PBProject {
    public static final int NSApplicationDirectory = 1;
    public static final int NSDemoApplicationDirectory = 2;
    public static final int NSDeveloperApplicationDirectory = 3;
    public static final int NSAdminApplicationDirectory = 4;
    public static final int NSLibraryDirectory = 5;
    public static final int NSDeveloperDirectory = 6;
    public static final int NSUserDirectory = 7;
    public static final int NSDocumentationDirectory = 8;
    public static final int NSAllApplicationsDirectory = 100;
    public static final int NSAllLibrariesDirectory = 101;
    public static final int NSUserDomainMask = 1;
    public static final int NSLocalDomainMask = 2;
    public static final int NSNetworkDomainMask = 4;
    public static final int NSSystemDomainMask = 8;
    public static final int NSAllDomainsMask = 65535;
    public static final int TOUCHED_NOTHING = 0;
    public static final int TOUCHED_EVERYTHING = 1;
    public static final int TOUCHED_PROJECT_NAME = 2;
    public static final int TOUCHED_LANGUAGE = 4;
    public static final int TOUCHED_PROJECT_TYPE = 8;
    public static final int TOUCHED_INSTALL_DIR = 16;
    public static final int TOUCHED_ICON_NAMES = 32;
    public static final int TOUCHED_FILES = 64;
    public static final int TOUCHED_MAINNIB = 128;
    public static final int TOUCHED_APPCLASS = 256;
    public static final int TOUCHED_TARGETS = 512;
    public static final int TOUCHED_PB_PROJECT = 1024;
    public static final int TOUCHED_SYST_EXT = 2048;
    public static final int TOUCHED_EXTENSION = 4096;
    public static final int TOUCHED_PATHS = 8192;
    public static final String PB_ClassesKey = "CLASSES";
    public static final String PB_HeadersKey = "H_FILES";
    public static final String PB_OtherSourcesKey = "OTHER_LINKED";
    public static final String PB_OtherResourcesKey = "OTHER_RESOURCES";
    public static final String PB_SupportingFilesKey = "OTHER_SOURCES";
    public static final String PB_ProjectHeadersKey = "PROJECT_HEADERS";
    public static final String PB_PublicHeadersKey = "PUBLIC_HEADERS";
    public static final String PB_PrecompiledHeadersKey = "PRECOMPILED_HEADERS";
    public static final String PB_SubprojectsKey = "SUBPROJECTS";
    public static final String PB_InterfacesKey = "INTERFACES";
    public static final String PB_ImagesKey = "IMAGES";
    public static final String PB_LocalizableFilesKey = "LOCALIZABLE_FILES";
    public static final String PB_FrameworksKey = "FRAMEWORKS";
    public static final String PB_OtherLibsKey = "OTHER_LIBS";
    public static final String PB_WOAppResourcesKey = "WOAPP_RESOURCES";
    public static final String PB_ComponentsKey = "WEBCOMPONENTS";
    public static final String PB_ResourcesKey = "RESOURCES";
    static String PBProjectWillUpgradeNotification = "Project Will Upgrade";
    static String PBProjectDidUpgradeNotification = "Project Upgraded";
    static String PBProjectDidChangeNotification = "Project Changed";
    static String PBProjectWillSaveNotification = "Project Will Save";
    static String PBProjectDidSaveNotification = "Project Saved";
    static String PBProjectSaveDidFailNotification = "Project Save Failed";
    static String PBFileAddedToProjectNotification = "File Added to Project";
    static String PBFileRemovedFromProjectNotification = "File Removed from Project";
    static NSMutableDictionary canonicalFileToProject = new NSMutableDictionary();
    static NSNotificationCenter notificationCenter = NSNotificationCenter.defaultCenter();
    static String latestProjectVersion = "2.6";
    static NSMutableDictionary _canonicalFileToProject = new NSMutableDictionary();
    static Object _projectParseLock = new Object();
    public static int _PBPort;
    public static String _PBHostname;
    NSMutableDictionary _dict;
    String _projectDir;
    String _languageDirCache;
    NSMutableArray _subProjects;
    NSMutableDictionary _userInfoDict;
    _PBProject _superProject;
    String _canonicalFile;
    long _fileModTime;
    long _touched;
    NSMutableArray<String> _resolvedNSProjectSearchPath = null;
    NSMutableArray<String> _lastNSProjectSearchPath = null;
    volatile boolean _rememberFileAttributes;
    private static String pbProjectSuffix;
    static NSMutableArray<String> _defaultPaths;
    static NSMutableArray _fwStack;

    static {
        String value = NSProperties.getProperty((String)"ProjectBuilderWOPort", (String)"8546");
        try {
            _PBPort = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.err.appendln((Object)("_PBProject: exception while reading property 'ProjectBuilderPort'. The value '" + value + "' is not an integer. Using port 8546 by default."));
            }
            _PBPort = 8546;
        }
        _PBHostname = NSProperties.getProperty((String)"ProjectBuilderWOHost", (String)"localhost");
        pbProjectSuffix = String.valueOf(File.separator) + "PB.project";
        _defaultPaths = null;
    }

    public static _PBProject pbProjectAtPath(String path) {
        _PBProject pbProject = null;
        String canonicalPath = NSPathUtilities.stringByNormalizingExistingPath((String)path);
        if (!canonicalPath.endsWith(pbProjectSuffix)) {
            canonicalPath = String.valueOf(canonicalPath) + pbProjectSuffix;
        }
        pbProject = _PBProject.parse(canonicalPath);
        return pbProject;
    }

    public void setObjectForKey(Object anObject, String key) {
        this._dict.setObjectForKey(anObject, (Object)key);
    }

    public Object objectForKey(String key) {
        return this._dict.objectForKey((Object)key);
    }

    public void renameProject(String pathName) {
    }

    public void removeObjectForKey(String key) {
        this._dict.removeObjectForKey((Object)key);
    }

    public String _canonicalFile() {
        return this._canonicalFile;
    }

    public String _projectDir() {
        return this._projectDir;
    }

    public _PBProject rootProject() {
        _PBProject superProj = this.superProject();
        if (superProj != null) {
            return superProj.rootProject();
        }
        return this;
    }

    public _PBProject superProject() {
        return this._superProject;
    }

    public String languageDir() {
        if (this._languageDirCache == null) {
            this._languageDirCache = NSPathUtilities.stringByAppendingPathComponent((String)this._projectDir, (String)(String.valueOf(this.languageName()) + ".lproj"));
        }
        return this._languageDirCache;
    }

    public long _touched() {
        return this._touched;
    }

    public void setTouched(long touch) {
        this._touched = touch == 0L ? 0L : (this._touched |= touch);
    }

    public String projectType() {
        return "WebObjects Application (fixme)";
    }

    public String projectTypeName() {
        return (String)this._dict.objectForKey((Object)"PROJECTTYPE");
    }

    public String projectName() {
        return (String)this._dict.objectForKey((Object)"PROJECTNAME");
    }

    public String appIconFileForOSType(int anOS) {
        return (String)this._dict.objectForKey((Object)_PBProject.prefixStringWithOSType("APPICON", anOS));
    }

    public String appHelpFileForOSType(int anOS) {
        return (String)this._dict.objectForKey((Object)_PBProject.prefixStringWithOSType("HELPFILE", anOS));
    }

    public String versionNb() {
        return (String)this._dict.objectForKey((Object)"VERSIONNB");
    }

    public String bundleExtension() {
        String extension = (String)this._dict.objectForKey((Object)"BUNDLE_EXTENSION");
        return extension != null ? extension : "bundle";
    }

    public String languageName() {
        return System.getProperty("user.language");
    }

    public String applicationClass() {
        String key = "APPCLASS";
        Object appClass = this._dict.objectForKey((Object)key);
        if (appClass == null && this.projectTypeName().equals("Application")) {
            appClass = "NSApplication";
            this._dict.setObjectForKey(appClass, (Object)key);
        }
        return (String)appClass;
    }

    public String mainNibFileForOSType(int anOSType) {
        return (String)this._dict.objectForKey((Object)_PBProject.prefixStringWithOSType("MAINNIB", anOSType));
    }

    public static String prefixStringWithOSType(String s, int type) {
        return String.valueOf(s) + type;
    }

    public NSMutableArray docExtensionsForOSType(int anOSType) {
        String key = _PBProject.prefixStringWithOSType("DOCUMENTEXTENSIONS", anOSType);
        Object docIconFiles = this._dict.objectForKey((Object)key);
        if (docIconFiles == null) {
            docIconFiles = new NSMutableArray();
            this._dict.setObjectForKey(docIconFiles, (Object)key);
        }
        return (NSMutableArray)docIconFiles;
    }

    public String shouldGenerateMain() {
        String key = "GENERATEMAIN";
        Object generate = this._dict.objectForKey((Object)key);
        if (generate == null) {
            generate = "YES";
            this._dict.setObjectForKey(generate, (Object)key);
        }
        return (String)generate;
    }

    public String projectVersion() {
        String key = "PROJECTVERSION";
        Object version = this._dict.objectForKey((Object)key);
        if (version == null) {
            version = "";
            this._dict.setObjectForKey(version, (Object)key);
        }
        return (String)version;
    }

    public void setProjectVersion(String version) {
        this._dict.setObjectForKey((Object)version, (Object)"PROJECTVERSION");
    }

    public void addSystemExtensions(String ext) {
        if (!this.systemExtensions().containsObject((Object)ext)) {
            ((NSMutableArray)this.systemExtensions()).addObject((Object)ext);
        }
    }

    public NSArray systemExtensions() {
        String key = "SYSTEMEXTENSIONS";
        Object systemExtensions = this._dict.objectForKey((Object)key);
        if (systemExtensions == null) {
            systemExtensions = new NSMutableArray();
            this._dict.setObjectForKey(systemExtensions, (Object)key);
        }
        return (NSArray)systemExtensions;
    }

    public void setShouldGenerateMain(String shoudI) {
        this._dict.setObjectForKey((Object)shoudI, (Object)"GENERATEMAIN");
    }

    public void setProjectDir(String dir) {
        this._projectDir = dir;
    }

    public void setVersionNb(String vn) {
        this._dict.setObjectForKey((Object)vn, (Object)"VERSIONNB");
    }

    public void setProjectType(String type) {
        this._dict.setObjectForKey((Object)type, (Object)"PROJECTTYPE");
    }

    public void setProjectName(String name) {
        this._dict.setObjectForKey((Object)name, (Object)"PROJECTNAME");
    }

    public void setLanguageName(String l) {
        this._dict.setObjectForKey((Object)l, (Object)"LANGUAGE");
        this._languageDirCache = null;
    }

    public void setAppIconFileForOSType(String iconFile, int anOS) {
        String key = _PBProject.prefixStringWithOSType("APPICON", anOS);
        if (!this._dict.objectForKey((Object)key).equals(iconFile)) {
            if (iconFile != null && iconFile.length() > 0) {
                this._dict.setObjectForKey((Object)iconFile, (Object)key);
            } else {
                this._dict.removeObjectForKey((Object)key);
            }
        }
    }

    public void setAppHelpFileForOSType(String helpFile, int anOS) {
        String key = _PBProject.prefixStringWithOSType("HELPFILE", anOS);
        if (!this._dict.objectForKey((Object)key).equals(helpFile)) {
            if (helpFile != null && helpFile.length() > 0) {
                this._dict.setObjectForKey((Object)helpFile, (Object)key);
            } else {
                this._dict.removeObjectForKey((Object)key);
            }
        }
    }

    public void setApplicationClass(String appClass) {
        this._dict.setObjectForKey((Object)appClass, (Object)"APPCLASS");
    }

    public void setMainNibFileForOSType(String mainNib, int anOS) {
        String key = _PBProject.prefixStringWithOSType("MAINNIB", anOS);
        if (mainNib != null && mainNib.length() > 0) {
            this._dict.setObjectForKey((Object)mainNib, (Object)key);
        } else {
            this._dict.removeObjectForKey((Object)key);
        }
    }

    public void setBundleExtension(String ext) {
        this._dict.setObjectForKey((Object)ext, (Object)"BUNDLE_EXTENSION");
    }

    public NSMutableDictionary<String, NSMutableArray<String>> filesTable() {
        String key = "FILESTABLE";
        Object filesTable = this._dict.objectForKey((Object)key);
        if (filesTable == null) {
            filesTable = new NSMutableDictionary();
            this._dict.setObjectForKey(filesTable, (Object)key);
        }
        return (NSMutableDictionary)filesTable;
    }

    public NSMutableArray<String> fileListForKey(String aKey) {
        return this.fileListForKey(aKey, true);
    }

    public NSMutableArray<String> fileListForKey(String aKey, boolean createIt) {
        NSMutableArray fileList = (NSMutableArray)this.filesTable().objectForKey((Object)aKey);
        if (createIt && fileList == null && aKey != null && !aKey.equals("")) {
            fileList = new NSMutableArray();
            this.filesTable().setObjectForKey((Object)fileList, (Object)aKey);
        }
        return fileList;
    }

    public NSArray<String> otherLinkedOFiles() {
        NSMutableArray otherLinkedFiles = (NSMutableArray)this.filesTable().objectForKey((Object)PB_OtherSourcesKey);
        if (otherLinkedFiles != null) {
            int count = otherLinkedFiles.count();
            NSMutableArray otherLinkedOFiles = new NSMutableArray();
            int i = 0;
            while (i < count) {
                otherLinkedOFiles.addObject((Object)(String.valueOf((String)otherLinkedFiles.objectAtIndex(i)) + "o"));
                ++i;
            }
            return otherLinkedOFiles;
        }
        return null;
    }

    public static NSDictionary projectFileDict(_PBProject proj, String file) {
        NSMutableDictionary dict = new NSMutableDictionary();
        dict.setObjectForKey((Object)proj, (Object)"project");
        dict.setObjectForKey((Object)file, (Object)"file");
        return dict;
    }

    public void addFileKey(String aFile, String aKey) {
        NSMutableArray<String> fileList = this.fileListForKey(aKey);
        if (!fileList.containsObject((Object)aFile)) {
            fileList.addObject((Object)aFile);
        }
        notificationCenter.postNotification(PBFileAddedToProjectNotification, (Object)_PBProject.projectFileDict(this, aFile));
    }

    public void addFileToFrontKey(String aFile, String aKey) {
        NSMutableArray<String> fileList = this.fileListForKey(aKey);
        fileList.removeObject((Object)aFile);
        fileList.insertObjectAtIndex((Object)aFile, 0);
        notificationCenter.postNotification(PBFileAddedToProjectNotification, (Object)_PBProject.projectFileDict(this, aFile));
    }

    public void removeFileKey(String aFile, String aKey) {
        this.fileListForKey(aKey, false).removeObject((Object)aFile);
        this.mutableLocalFiles().removeObjectForKey((Object)aFile);
        notificationCenter.postNotification(PBFileRemovedFromProjectNotification, (Object)_PBProject.projectFileDict(this, aFile));
    }

    public String keyForFile(String aFile) {
        NSMutableDictionary<String, NSMutableArray<String>> filesTable = this.filesTable();
        Enumeration enumerator = filesTable.keyEnumerator();
        while (enumerator.hasMoreElements()) {
            String key = (String)enumerator.nextElement();
            NSArray array = (NSArray)filesTable.objectForKey((Object)key);
            if (!array.containsObject((Object)aFile)) continue;
            return key;
        }
        return null;
    }

    public NSDictionary localFiles() {
        String key = PB_LocalizableFilesKey;
        Object localFiles = this._dict.objectForKey((Object)key);
        if (localFiles == null) {
            localFiles = new NSMutableDictionary();
            this._dict.setObjectForKey(localFiles, (Object)key);
        }
        return (NSDictionary)localFiles;
    }

    public NSMutableDictionary mutableLocalFiles() {
        return (NSMutableDictionary)this.localFiles();
    }

    public boolean isLocalizable(String aFile) {
        return this.mutableLocalFiles().objectForKey((Object)aFile) != null;
    }

    public void makeFileLocalizable(String aFile, boolean loc) {
        NSMutableDictionary localFiles = this.mutableLocalFiles();
        if (loc) {
            localFiles.setObjectForKey((Object)aFile, (Object)aFile);
        } else {
            localFiles.removeObjectForKey((Object)aFile);
        }
    }

    public boolean rememberFileAttributes() {
        return this._rememberFileAttributes;
    }

    public void setRememberFileAttributes(boolean aValue) {
        this._rememberFileAttributes = aValue;
    }

    public void updateFileAttributesFromPath(String path) {
    }

    public boolean writeToPathSafely(String path, boolean safe) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static _PBProject parse(String pathName) {
        String canFile = _PBProject.canonicalFileName(NSPathUtilities.stringByNormalizingExistingPath((String)pathName));
        if (canFile == null || canFile.length() == 0) {
            return null;
        }
        _PBProject project = (_PBProject)_canonicalFileToProject.objectForKey((Object)canFile);
        Object object = _projectParseLock;
        synchronized (object) {
            block8: {
                try {
                    NSMutableDictionary fileContents;
                    if (project != null && !project.rememberFileAttributes()) {
                        project._dict = _PBProject.readPBProjectFile(project._canonicalFile);
                        project.setTouched(1024L);
                    }
                    if (project == null && (fileContents = _PBProject.readPBProjectFile(canFile)) != null && fileContents.count() > 0) {
                        project = new _PBProject();
                        project._dict = fileContents;
                        project._touched = 0L;
                        project._canonicalFile = canFile;
                        project._superProject = null;
                        _canonicalFileToProject.setObjectForKey((Object)project, (Object)project._canonicalFile);
                        project.setProjectDir(_NSStringUtilities.stringByDeletingLastComponent((String)canFile, (char)File.separatorChar));
                        project.setTouched(0L);
                        project.setRememberFileAttributes(true);
                        project.postParseProcess();
                    }
                }
                catch (Exception e) {
                    if (!NSLog.debugLoggingAllowedForLevel((int)3)) break block8;
                    NSLog.debug.appendln((Object)("Problem parsing " + pathName));
                    NSLog._conditionallyLogPrivateException((Throwable)e);
                }
            }
        }
        return project;
    }

    public NSArray parseSubprojects() {
        NSMutableArray<String> names = this.fileListForKey(PB_SubprojectsKey, false);
        if (names != null) {
            int count = names.count();
            int idx = 0;
            while (idx < count) {
                String proj = (String)names.objectAtIndex(idx);
                this.parseSubproject(proj);
                ++idx;
            }
        }
        return this._subProjects;
    }

    public _PBProject parseSubproject(String subDir) {
        String aSubDir = String.valueOf(this.projectDir()) + File.separator + subDir;
        String subFile = String.valueOf(aSubDir) + File.separator + "PB.project";
        _PBProject subproject = _PBProject.parse(subFile);
        if (subproject == null) {
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.err.appendln((Object)("Unable to open project file: " + subFile));
            }
            return null;
        }
        if (subproject._superProject == null) {
            subproject._superProject = this;
        }
        if (this._subProjects == null) {
            this._subProjects = new NSMutableArray();
        }
        if (!this._subProjects.containsObject((Object)subproject)) {
            this._subProjects.addObject((Object)subproject);
        }
        return subproject;
    }

    public void postParseProcess() {
    }

    public static NSMutableDictionary readPBProjectFile(String path) throws MalformedURLException {
        return NSPropertyListSerialization.dictionaryWithPathURL((URL)new File(path).toURL()).mutableClone();
    }

    public String projectDir() {
        return this._projectDir;
    }

    public _PBProject nonAggregateRootProject() {
        return this;
    }

    public static String canonicalFileName(String standardizedPath) {
        return standardizedPath;
    }

    public String specifiedPathForFrameworkNamed(String fwName) {
        String fwPath = null;
        return fwPath;
    }

    public static String environmentVariableValueForString(String inString) {
        if (inString.equals("NEXT_ROOT")) {
            return "D:\\Apple\\";
        }
        if (inString.equals("LOCAL_LIBRARY_DIR")) {
            return "Local\\Library";
        }
        if (inString.equals("LIBRARY_DIR")) {
            return "Library";
        }
        return "*UNKNOWN*";
    }

    public static String stringByExpandingEnvironmentVariablesInString(String inString) {
        int length = inString.length();
        int varInd = inString.indexOf("$(");
        if (varInd < 0) {
            return inString;
        }
        String preFix = inString.substring(0, varInd);
        int startInd = varInd += 2;
        while (varInd < length) {
            if (inString.charAt(varInd) == ')') {
                String varName = inString.substring(startInd, varInd);
                String postFix = _PBProject.stringByExpandingEnvironmentVariablesInString(inString.substring(varInd + 1, length));
                return String.valueOf(preFix) + _PBProject.environmentVariableValueForString(varName) + postFix;
            }
            ++varInd;
        }
        return inString;
    }

    public String deployedPathForFrameworkNamed(String fwName) {
        String path2;
        NSMutableArray<String> fileList = this.fileListForKey("FRAMEWORKSEARCH", false);
        if (fileList == null) {
            return null;
        }
        String fwPath = null;
        Iterator pathIterator = fileList.iterator();
        while (pathIterator.hasNext()) {
            path2 = (String)pathIterator.next();
            fwPath = String.valueOf(path2 = _PBProject.stringByExpandingEnvironmentVariablesInString(path2)) + File.separator + fwName;
            if (new File(fwPath).exists()) break;
            fwPath = null;
        }
        if (fwPath == null) {
            if (_defaultPaths == null) {
                _defaultPaths = new NSMutableArray();
                while (pathIterator.hasNext()) {
                    path2 = (String)pathIterator.next();
                    _defaultPaths.addObject((Object)(String.valueOf(path2) + File.separator + "Frameworks"));
                    _defaultPaths.addObject((Object)(String.valueOf(path2) + File.separator + "PrivateFrameworks"));
                }
            }
            for (String path2 : _defaultPaths) {
                fwPath = String.valueOf(path2) + File.separator + fwName;
                if (new File(fwPath).exists()) break;
                fwPath = null;
            }
        }
        return fwPath;
    }

    public String searchedPathForFrameworkNamed(String fwName) {
        NSArray frameworks = NSBundle.frameworkBundles();
        Enumeration enumerator = frameworks.objectEnumerator();
        while (enumerator.hasMoreElements()) {
            NSBundle bundle = (NSBundle)enumerator.nextElement();
            String path = bundle.bundlePathURL().getPath();
            String lastcomponent = NSPathUtilities.lastPathComponent((String)path);
            if (!lastcomponent.equals(fwName)) continue;
            return path;
        }
        return null;
    }

    public String pathForFrameworkNamed(String fwName) {
        String fwPath = this.specifiedPathForFrameworkNamed(fwName);
        if (fwPath == null) {
            fwPath = this.searchedPathForFrameworkNamed(fwName);
        }
        return fwPath;
    }

    public void _addFrameworkDependenciesToArray(NSMutableArray array) {
        Enumeration enumerator = this._allFrameworkDependencies().objectEnumerator();
        while (enumerator.hasMoreElements()) {
            _PBProject fwProj = (_PBProject)enumerator.nextElement();
            if (array.containsObject((Object)fwProj)) continue;
            array.addObject((Object)fwProj);
        }
    }

    private NSArray _allFrameworkDependencies() {
        NSMutableArray array = new NSMutableArray();
        if (!_fwStack.containsObject((Object)this)) {
            NSMutableArray<String> fwArray = this.fileListForKey(PB_FrameworksKey, false);
            Enumeration enumerator = this.fileListForKey(PB_SubprojectsKey, false).objectEnumerator();
            _fwStack.addObject((Object)this);
            while (enumerator.hasMoreElements()) {
                String string = (String)enumerator.nextElement();
            }
            enumerator = fwArray.objectEnumerator();
            while (enumerator.hasMoreElements()) {
                _PBProject fwProj;
                String filename = (String)enumerator.nextElement();
                String fwPath = this.pathForFrameworkNamed(filename);
                String fwProjectPath = String.valueOf(fwPath) + File.separator + "PB.project";
                if (NSPathUtilities.pathExtension((String)fwPath).equals("framework") || !new File(fwProjectPath).exists() || !array.containsObject((Object)(fwProj = _PBProject.parse(fwProjectPath)))) continue;
                fwProj._addFrameworkDependenciesToArray(array);
                array.addObject((Object)fwProj);
            }
        }
        return array;
    }

    public NSArray pathsForProjectNamed(String projectName) {
        NSMutableArray foundProjectsArray = new NSMutableArray();
        NSMutableArray projectSearchPath = new NSMutableArray();
        NSMutableArray frameworkEntries = new NSMutableArray();
        String rootProjectDir = this.rootProject().projectDir();
        String projectParentDir = _NSStringUtilities.stringByDeletingLastComponent((String)rootProjectDir, (char)File.separatorChar);
        if (projectSearchPath == null) {
            // empty if block
        }
        if (!projectSearchPath.isEqualToArray(this._lastNSProjectSearchPath)) {
            this._lastNSProjectSearchPath = projectSearchPath.mutableClone();
            this._resolvedNSProjectSearchPath = new NSMutableArray();
            for (String projectPath : projectSearchPath) {
                if (!new File(projectPath).isAbsolute()) {
                    projectPath = String.valueOf(rootProjectDir) + File.separator + projectPath;
                }
                projectPath = NSPathUtilities.stringByStandardizingPath((String)projectPath);
                this._resolvedNSProjectSearchPath.addObject((Object)projectPath);
            }
            if (!this._resolvedNSProjectSearchPath.containsObject((Object)projectParentDir)) {
                this._resolvedNSProjectSearchPath.addObject((Object)projectParentDir);
            }
        }
        for (String projectPath : this._resolvedNSProjectSearchPath) {
            String[] contents = new File(projectPath).list();
            int j = 0;
            while (contents != null && j < contents.length) {
                String pbProjectDir;
                String pbPath;
                String file = contents[j];
                if (NSPathUtilities.pathIsEqualToString((String)file, (String)projectName) && new File(pbPath = String.valueOf(pbProjectDir = String.valueOf(projectPath) + File.separator + file) + File.separator + "PB.project").exists()) {
                    foundProjectsArray.addObject((Object)pbProjectDir);
                }
                ++j;
            }
            for (String file : frameworkEntries) {
                String pbProjectDir = String.valueOf(projectPath) + File.separator + file;
                String pbPath = String.valueOf(pbProjectDir) + File.separator + "PB.project";
                if (!new File(pbPath).exists()) continue;
                foundProjectsArray.insertObjectAtIndex((Object)pbProjectDir, 0);
            }
        }
        return foundProjectsArray;
    }

    public NSArray allFrameworkDependencies() {
        _fwStack = new NSMutableArray();
        NSArray fwDepends = this._allFrameworkDependencies();
        _fwStack = null;
        return fwDepends;
    }

    private void _initializeUserInfoDict() {
        String userInfoFilePath = this._currentUserCurrentOSPathForInfoFile();
        String OSName = this._userInfoCurrentOSName();
        if (new File(userInfoFilePath).exists()) {
            try {
                String contents = _NSStringUtilities.stringFromFile((String)userInfoFilePath, null);
                NSDictionary plist = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)contents);
                this._userInfoDict = plist.mutableClone();
                NSDictionary origOSDict = (NSDictionary)this._userInfoDict.objectForKey((Object)OSName);
                if (origOSDict != null) {
                    NSMutableDictionary newOSDict = origOSDict.mutableClone();
                    this._userInfoDict.takeValueForKey((Object)newOSDict, OSName);
                }
            }
            catch (Exception e) {
                NSLog._conditionallyLogPrivateException((Throwable)e);
                this._userInfoDict = null;
            }
        }
        if (this._userInfoDict == null) {
            this._userInfoDict = new NSMutableDictionary();
        }
        if (this._userInfoDict.objectForKey((Object)OSName) == null) {
            this._userInfoDict.takeValueForKey((Object)new NSMutableDictionary(), OSName);
        }
    }

    private String _userInfoFileName() {
        String userName = System.getProperty("user.name");
        String fileName = "PBUserInfo_" + userName + ".plist";
        return fileName;
    }

    private String _userInfoDirectoryPath() {
        String projectDirectory = this.projectDir();
        return String.valueOf(projectDirectory) + File.separator + "PBUserInfo";
    }

    private String _currentUserCurrentOSPathForInfoFile() {
        return String.valueOf(this._userInfoDirectoryPath()) + File.separator + this._userInfoFileName();
    }

    private String _userInfoCurrentOSName() {
        String name = System.getProperty("os.name");
        if (name.equals("Rhapsody")) {
            name = "NSMACHOperatingSystem";
        } else if (name.equals("Windows NT")) {
            name = "NSWindowsNTOperatingSystem";
        } else {
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.err.appendln((Object)("_userInfoCurrentOSName unknown OS " + name));
            }
            name = "SomeUnknownOperatingSystem";
        }
        return name;
    }

    private NSMutableDictionary _userInfoDict() {
        if (this._userInfoDict == null) {
            this._initializeUserInfoDict();
        }
        return this._userInfoDict;
    }

    private NSMutableDictionary _userInfoDictForCurrentOS() {
        NSMutableDictionary userDict = this._userInfoDict();
        return (NSMutableDictionary)userDict.objectForKey((Object)this._userInfoCurrentOSName());
    }

    public NSDictionary currentUserCurrentOSObjectForKey(Object aKey) {
        return (NSDictionary)this._userInfoDictForCurrentOS().objectForKey(aKey);
    }

    static int addFileToPBBucket(String projectName, String fileName, String bucketName) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("<AddFile>");
        buffer.append("<projectname>" + projectName + "</projectname>");
        buffer.append("<filepath>" + fileName + "</filepath>");
        buffer.append("<pbresource>" + bucketName + "</pbresource>");
        buffer.append("</AddFile>");
        String result = _PBProject._sendXMLToPB(new String(buffer));
        if (result != null) {
            if (NSLog.debugLoggingAllowedForLevel((int)1)) {
                NSLog.err.appendln((Object)("Error: Could not add " + fileName + " to project " + projectName + " because " + result));
            }
            return 1;
        }
        return 0;
    }

    public static String openFile(String filename, int line, String errorMessage) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("<OpenFile><filename>");
        buffer.append(filename);
        buffer.append("</filename><linenumber>");
        buffer.append(line);
        buffer.append("</linenumber><message>");
        buffer.append(errorMessage);
        buffer.append("</message></OpenFile>");
        String pbString = new String(buffer);
        String result = _PBProject._sendXMLToPB(pbString);
        return result;
    }

    private static String _sendXMLToPB(String command) {
        block2: {
            try {
                Socket pbSocket = new Socket(_PBHostname, _PBPort);
                OutputStream os = pbSocket.getOutputStream();
                os.write(command.getBytes());
                os.flush();
                pbSocket.close();
            }
            catch (Exception e) {
                if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)4L)) break block2;
                NSLog.err.appendln((Object)("<_PBProject>: Exception occurred during _sendXMLToPB():" + e.getMessage()));
                NSLog._conditionallyLogPrivateException((Throwable)e);
            }
        }
        return null;
    }
}

