/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRCriteria;
import er.grouping.DRGroup;
import er.grouping.DRRecord;
import er.grouping.DRRecordGroup;
import er.grouping.DRSubMasterCriteria;
import java.util.Enumeration;

public class DRMasterCriteria {
    protected NSMutableDictionary _userInfo = new NSMutableDictionary();
    protected NSArray _subCriteriaList;
    protected boolean _isPreset;
    protected boolean _useStringMatchForLookup;
    protected NSMutableDictionary _criteriaLookupDict = new NSMutableDictionary();
    protected String _label = null;
    private String _keyDesc = null;

    public static DRMasterCriteria withSubMasterCriteriaUserInfo(NSArray smcList, NSDictionary info) {
        DRMasterCriteria aVal = new DRMasterCriteria();
        aVal.initWithSubMasterCriteria(smcList, info);
        return aVal;
    }

    public boolean shouldTotal() {
        if (this._userInfo == null) {
            return true;
        }
        return ERXValueUtilities.booleanValue((Object)this._userInfo.objectForKey((Object)"SHOW_TOTAL"));
    }

    public boolean shouldShowOther() {
        if (this._userInfo == null) {
            return true;
        }
        return ERXValueUtilities.booleanValue((Object)this._userInfo.objectForKey((Object)"SHOW_OTHER"));
    }

    public boolean isString() {
        if (this._userInfo == null) {
            return true;
        }
        return ERXValueUtilities.booleanValue((Object)this._userInfo.objectForKey((Object)"IS_STRING"));
    }

    public DRMasterCriteria initWithSubMasterCriteria(NSArray smcList, NSDictionary info) {
        this._subCriteriaList = new NSArray(smcList);
        this._userInfo.setObjectForKey((Object)"true", (Object)"SHOW_TOTAL");
        this._userInfo.setObjectForKey((Object)"true", (Object)"SHOW_OTHER");
        this._userInfo.setObjectForKey((Object)"false", (Object)"IS_STRING");
        this._userInfo.setObjectForKey((Object)"Other", (Object)"OTHER_LABEL");
        this._userInfo.setObjectForKey((Object)"Total", (Object)"TOTAL_LABEL");
        this._userInfo.setObjectForKey((Object)"%m/%d/%Y", (Object)"calendarFormat");
        this._userInfo.setObjectForKey((Object)" to ", (Object)"rangeSeparator");
        this._userInfo.setObjectForKey((Object)"|", (Object)"compoundSeparator");
        this._userInfo.addEntriesFromDictionary(info);
        this._useStringMatchForLookup = this.decideLookupMethod(this._subCriteriaList);
        this._isPreset = this.decideIsPreset(this._subCriteriaList);
        if (this.isPreset()) {
            this.criteriaWithPossibleValues();
        }
        return this;
    }

    public NSMutableDictionary userInfo() {
        return this._userInfo;
    }

    public NSArray subCriteriaList() {
        return this._subCriteriaList;
    }

    public boolean useStringMatchForLookup() {
        return this._useStringMatchForLookup;
    }

    public boolean decideLookupMethod(NSArray scList) {
        Enumeration anEnum = scList.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRSubMasterCriteria scSub = (DRSubMasterCriteria)anEnum.nextElement();
            if (!scSub.mustSearchForLookup()) continue;
            return false;
        }
        return true;
    }

    public boolean isPreset() {
        return this._isPreset;
    }

    public boolean decideIsPreset(NSArray scList) {
        Enumeration anEnum = scList.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRSubMasterCriteria scSub = (DRSubMasterCriteria)anEnum.nextElement();
            if (scSub.isPreset()) continue;
            return false;
        }
        return true;
    }

    public NSDictionary valueDictFromValuesRecord(NSDictionary vlDict, DRRecord rec) {
        NSMutableDictionary dict = new NSMutableDictionary();
        String ky = "|";
        Enumeration anEnum = this._subCriteriaList.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            DRSubMasterCriteria smc = (DRSubMasterCriteria)anEnum.nextElement();
            Object val = null;
            val = vlDict != null ? vlDict.objectForKey((Object)smc.keyDesc()) : smc.lookUpValueForRecord(rec);
            if (val == null) {
                return null;
            }
            String pky = smc.lookUpKeyForValue(val);
            dict.setObjectForKey(val, (Object)smc.keyDesc());
            ky = ky + pky + "|";
        }
        dict.setObjectForKey((Object)ky, (Object)"lookupKey");
        return dict;
    }

    public NSDictionary valueDictRecord(DRRecord rec) {
        return this.valueDictFromValuesRecord(null, rec);
    }

    public NSDictionary valueDictFromValues(NSDictionary vlDict) {
        return this.valueDictFromValuesRecord(vlDict, null);
    }

    public void criteriaWithPossibleValueList(NSDictionary vlDict) {
        NSDictionary valueDict = this.valueDictFromValues(vlDict);
        String lookupKey = (String)valueDict.objectForKey((Object)"lookupKey");
        DRCriteria crit = DRCriteria.withMasterCriteriaValueDict(this, valueDict);
        this._criteriaLookupDict.setObjectForKey((Object)crit, (Object)lookupKey);
    }

    public NSDictionary criteriaLookupDict() {
        return this._criteriaLookupDict;
    }

    public void walkPresetsPossibleValues(NSArray presets, NSDictionary vlDict) {
        DRSubMasterCriteria scSub = (DRSubMasterCriteria)presets.objectAtIndex(0);
        NSMutableArray newPresets = new NSMutableArray(presets);
        Enumeration anEnum = scSub.possibleValues().objectEnumerator();
        newPresets.removeObjectAtIndex(0);
        int count = newPresets.count();
        while (anEnum.hasMoreElements()) {
            Object possibleValue = anEnum.nextElement();
            NSMutableDictionary moreVlDict = new NSMutableDictionary(vlDict);
            moreVlDict.setObjectForKey(possibleValue, (Object)scSub.keyDesc());
            if (count == 0) {
                this.criteriaWithPossibleValueList((NSDictionary)moreVlDict);
                continue;
            }
            this.walkPresetsPossibleValues((NSArray)newPresets, (NSDictionary)moreVlDict);
        }
    }

    private void criteriaWithPossibleValues() {
        this.walkPresetsPossibleValues(this._subCriteriaList, new NSDictionary());
        if (this.isPreset()) {
            DRCriteria c;
            Object val;
            NSArray arr;
            DRSubMasterCriteria smc = (DRSubMasterCriteria)this._subCriteriaList.objectAtIndex(0);
            if (!smc.groupEdges() && (arr = this._criteriaLookupDict.allValues()).count() > 0 && (val = (c = (DRCriteria)arr.objectAtIndex(0)).valueDict().objectForKey((Object)smc.keyDesc())) instanceof String) {
                this._userInfo.setObjectForKey((Object)"true", (Object)"IS_STRING");
            }
            if (this.shouldShowOther()) {
                String lk = "|Other|";
                DRCriteria crit = DRCriteria.asOtherWithMasterCriteria(this);
                this._criteriaLookupDict.setObjectForKey((Object)crit, (Object)lk);
            }
        }
    }

    public void groupRecordRecordGroupsDictGroupParent(DRRecord rec, NSMutableDictionary recGrpDict, DRGroup grp, DRRecordGroup parent) {
        DRRecordGroup recGrp = this.findRecordGroupForRecordGroupsDictGroupParent(rec, recGrpDict, grp, parent);
        if (recGrp != null) {
            recGrp.recordList().addObject((Object)rec);
        }
    }

    public DRRecordGroup findRecordGroupForRecordGroupsDictGroupParent(DRRecord rec, NSMutableDictionary recGrpDict, DRGroup grp, DRRecordGroup parent) {
        DRRecordGroup recGrp = null;
        NSDictionary valueDict = this.valueDictRecord(rec);
        if (valueDict == null && !this.isPreset()) {
            return null;
        }
        DRCriteria crit = null;
        String lookupKey = null;
        if (valueDict != null) {
            lookupKey = (String)valueDict.objectForKey((Object)"lookupKey");
            crit = (DRCriteria)this._criteriaLookupDict.objectForKey((Object)lookupKey);
        }
        if (crit == null && this.isPreset()) {
            crit = (DRCriteria)this._criteriaLookupDict.objectForKey((Object)"|Other|");
            if (crit == null) {
                return null;
            }
            recGrp = (DRRecordGroup)recGrpDict.objectForKey((Object)crit.keyDesc());
            if (recGrp == null) {
                recGrp = DRRecordGroup.withCriteriaGroupParent(crit, grp, parent);
                recGrpDict.setObjectForKey((Object)recGrp, (Object)crit.keyDesc());
            }
        } else if (crit == null) {
            crit = DRCriteria.withMasterCriteriaValueDict(this, valueDict);
            recGrp = DRRecordGroup.withCriteriaGroupParent(crit, grp, parent);
            recGrpDict.setObjectForKey((Object)recGrp, (Object)crit.keyDesc());
            this._criteriaLookupDict.setObjectForKey((Object)crit, (Object)lookupKey);
        } else {
            recGrp = (DRRecordGroup)recGrpDict.objectForKey((Object)crit.keyDesc());
        }
        return recGrp;
    }

    public String label() {
        if (this._label == null) {
            this._label = (String)this._userInfo.objectForKey((Object)"label");
            if (this._label == null) {
                int i = 0;
                int count = this._subCriteriaList.count();
                Enumeration en = this._subCriteriaList.objectEnumerator();
                String lbl = "";
                while (en.hasMoreElements()) {
                    DRSubMasterCriteria smc = (DRSubMasterCriteria)en.nextElement();
                    lbl = lbl.concat(smc.label());
                    if (++i == count) continue;
                    lbl = lbl.concat("|");
                }
                this._label = lbl;
            }
        }
        return this._label;
    }

    public String keyDesc() {
        if (this._keyDesc == null) {
            this._keyDesc = super.toString();
        }
        return this._keyDesc;
    }

    public String toString() {
        return "<DRMasterCriteria label: \"" + this.label() + "\"; shouldTotal: " + this.shouldTotal() + "; subCriterias: " + this.subCriteriaList() + " >";
    }
}

