/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import er.extensions.foundation.ERXValueUtilities;
import er.grouping.DRCriteria;
import er.grouping.DRRecord;
import er.grouping.DRValueConverter;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class DRSubMasterCriteria {
    protected static final Logger log = Logger.getLogger(DRSubMasterCriteria.class);
    protected boolean _useMethod;
    protected String _key;
    protected boolean _useTimeFormat;
    protected static final NSArray _possibleUseTypes = new NSArray(new Object[]{"usePredefined", "useRange", "usePeriodic", "NONE"});
    protected String _format;
    protected boolean _groupEdges;
    protected NSArray _rawPossibleValues;
    protected NSMutableArray _possibleValues;
    protected double _periodicDelta;
    protected String _possibleValuesUseType;
    protected boolean _isPreset;
    protected boolean _isPeriodic;
    protected boolean _mustSearchForLookup;
    protected NSDictionary _presetLookupDict;
    protected NSSelector _selKey;
    protected boolean _nonNumberOrDate;
    protected String _label;
    private String _keyDesc = null;

    public static DRSubMasterCriteria withDefinitionDictionaryPossibleValues(NSDictionary smcdict, NSArray apossibleValues) {
        return new DRSubMasterCriteria(smcdict, apossibleValues);
    }

    public static DRSubMasterCriteria withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues(String akey, boolean auseMethod, boolean auseTimeFormat, String aformat, String apossibleValuesUseType, boolean agroupEdges, NSArray apossibleValues) {
        DRSubMasterCriteria aVal = new DRSubMasterCriteria(akey, auseMethod, auseTimeFormat, aformat, apossibleValuesUseType, agroupEdges, apossibleValues);
        return aVal;
    }

    public NSMutableArray possibleRangeValuesFromRawValues(NSArray rawPossVals) {
        Object highVal;
        Object lowVal;
        NSMutableArray possVals = new NSMutableArray();
        int rawCount = rawPossVals.count();
        int newCount = rawCount - 1;
        if (this.groupEdges()) {
            lowVal = "L";
            highVal = rawPossVals.objectAtIndex(0);
            possVals.addObject((Object)this.valDictMaxMin(highVal, lowVal));
        }
        for (int i = 0; i < newCount; ++i) {
            Object rawPossValLow = rawPossVals.objectAtIndex(i);
            Object rawPossValHigh = rawPossVals.objectAtIndex(i + 1);
            NSDictionary newPossVal = this.valDictMaxMin(rawPossValHigh, rawPossValLow);
            possVals.addObject((Object)newPossVal);
        }
        if (this.groupEdges()) {
            lowVal = rawPossVals.lastObject();
            highVal = "H";
            possVals.addObject((Object)this.valDictMaxMin(highVal, lowVal));
        }
        return possVals;
    }

    public DRSubMasterCriteria(NSDictionary smcdict, NSArray apossibleValues) {
        this((String)smcdict.objectForKey((Object)"key"), ERXValueUtilities.booleanValue((Object)smcdict.objectForKey((Object)"useMethod")), ERXValueUtilities.booleanValue((Object)smcdict.objectForKey((Object)"useTimeFormat")), (String)smcdict.objectForKey((Object)"format"), (String)smcdict.objectForKey((Object)"possibleValuesUseType"), ERXValueUtilities.booleanValue((Object)smcdict.objectForKey((Object)"groupEdges")), apossibleValues);
    }

    public DRSubMasterCriteria(String akey, boolean auseMethod, boolean auseTimeFormat, String aformat, String apossibleValuesUseType, boolean agroupEdges, NSArray apossibleValues) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("akey: " + akey));
            log.debug((Object)("auseMethod: " + auseMethod));
            log.debug((Object)("auseTimeFormat: " + auseTimeFormat));
            log.debug((Object)("aformat: " + aformat));
            log.debug((Object)("apossibleValuesUseType: " + apossibleValuesUseType));
            log.debug((Object)("agroupEdges: " + agroupEdges));
            log.debug((Object)("apossibleValues: " + apossibleValues));
        }
        this._label = null;
        this.setUseMethod(auseMethod);
        this.setUseTimeFormat(auseTimeFormat);
        this.setGroupEdges(agroupEdges);
        this.setKey(akey);
        this.setFormat(aformat);
        this.setPossibleValuesUseType(apossibleValuesUseType);
        this.setRawPossibleValues(apossibleValues);
        this._possibleValues = this.isPreset() && this.mustSearchForLookup() ? this.possibleRangeValuesFromRawValues(this._rawPossibleValues) : new NSMutableArray(this._rawPossibleValues);
        if (this.isPreset()) {
            this._presetLookupDict = this.buildPresetLookupDict();
        }
    }

    public String label() {
        if (this._label == null) {
            String lbl = this._key;
            if (this._useTimeFormat) {
                lbl = lbl + " " + this._format;
            }
            if (this._possibleValuesUseType != null) {
                lbl = lbl + " [" + this._possibleValuesUseType + "]";
            }
            this._label = lbl;
        }
        return this._label;
    }

    public NSDictionary buildPresetLookupDict() {
        NSMutableDictionary adict = new NSMutableDictionary();
        Enumeration anEnum = this._possibleValues.objectEnumerator();
        while (anEnum.hasMoreElements()) {
            Object aval = anEnum.nextElement();
            adict.setObjectForKey(aval, aval);
        }
        return new NSDictionary((NSDictionary)adict);
    }

    public DRSubMasterCriteria() {
    }

    public boolean nonNumberOrDate() {
        return this._nonNumberOrDate;
    }

    public boolean useMethod() {
        return this._useMethod;
    }

    public void setUseMethod(boolean v) {
        this._useMethod = v;
    }

    public boolean useTimeFormat() {
        return this._useTimeFormat;
    }

    public void setUseTimeFormat(boolean v) {
        this._useTimeFormat = v;
    }

    public boolean groupEdges() {
        return this._groupEdges;
    }

    public void setGroupEdges(boolean v) {
        this._groupEdges = v;
    }

    public String key() {
        return this._key;
    }

    public void setKey(String v) {
        this._key = v != null ? v : null;
        if (this._useMethod) {
            this._selKey = new NSSelector(this._key);
        }
    }

    public String format() {
        return this._format;
    }

    public void setFormat(String v) {
        if (this._useTimeFormat && v == null) {
            this._format = "";
            log.error((Object)("Can't have empty format when useTimeFormat=true: " + this));
        }
        this._format = v != null ? v : null;
    }

    protected boolean usePeriodic() {
        return "usePeriodic".equals(this._possibleValuesUseType);
    }

    protected boolean useRange() {
        return "useRange".equals(this._possibleValuesUseType);
    }

    protected boolean usePredefined() {
        return "usePredefined".equals(this._possibleValuesUseType);
    }

    public String possibleValuesUseType() {
        return this._possibleValuesUseType;
    }

    public void setPossibleValuesUseType(String v) {
        this._mustSearchForLookup = false;
        this._isPreset = false;
        if (v == null) {
            this._possibleValuesUseType = null;
        } else if (!_possibleUseTypes.containsObject((Object)v)) {
            log.error((Object)("Invalid possibleValuesUseType: " + v + ". Allowed are only: " + _possibleUseTypes + " " + this));
            this._possibleValuesUseType = null;
        } else {
            this._possibleValuesUseType = v;
            this._mustSearchForLookup = this.useRange() || this.usePeriodic();
            this._isPreset = this.useRange() || this.usePredefined();
            this._isPeriodic = this.usePeriodic();
        }
    }

    public NSArray rawPossibleValues() {
        return this._rawPossibleValues;
    }

    public void setRawPossibleValues(NSArray arr) {
        if (this._possibleValuesUseType != null && (arr == null || arr.count() == 0)) {
            log.warn((Object)("Should use possible values but got none: " + this));
            this._rawPossibleValues = NSArray.EmptyArray;
        } else {
            this._rawPossibleValues = new NSArray(arr);
            Object obj = this._rawPossibleValues.lastObject();
            if (!(obj instanceof String) && !(obj instanceof Number)) {
                this._nonNumberOrDate = true;
            }
        }
        if (this.isPeriodic()) {
            double v1 = DRValueConverter.converter().doubleForValue(this._rawPossibleValues.lastObject());
            double v2 = DRValueConverter.converter().doubleForValue(this._rawPossibleValues.objectAtIndex(0));
            this._periodicDelta = v1 - v2;
        }
    }

    public NSArray possibleValues() {
        return this._possibleValues;
    }

    public boolean isPreset() {
        return this._isPreset;
    }

    public boolean isPeriodic() {
        return this._isPeriodic;
    }

    public boolean mustSearchForLookup() {
        return this._mustSearchForLookup;
    }

    public NSDictionary valDictMaxMin(Object highVal, Object lowVal) {
        NSDictionary valDict = new NSDictionary(new Object[]{lowVal, highVal}, new Object[]{"L", "H"});
        return valDict;
    }

    public NSMutableArray possibleValuesToUse() {
        if (this.isPreset() && this.mustSearchForLookup()) {
            return new NSMutableArray(this._rawPossibleValues);
        }
        return this._possibleValues;
    }

    public NSDictionary valDictFromSearchForLookup(Object aval) {
        Object lowVal = null;
        Object highVal = null;
        NSMutableArray possibleValuesToUse = this.possibleValuesToUse();
        Object maxVal = possibleValuesToUse.lastObject();
        Object minVal = possibleValuesToUse.objectAtIndex(0);
        double v = DRValueConverter.converter().doubleForValue(aval);
        double maxv = DRValueConverter.converter().doubleForValue(maxVal);
        double minv = DRValueConverter.converter().doubleForValue(minVal);
        if (!this.isPeriodic()) {
            if (!this.groupEdges()) {
                if (v > maxv) {
                    return null;
                }
                if (v <= minv) {
                    return null;
                }
            } else {
                if (v > maxv) {
                    lowVal = maxVal;
                    highVal = "H";
                    return this.valDictMaxMin(highVal, lowVal);
                }
                if (v <= minv) {
                    lowVal = "L";
                    highVal = minVal;
                    return this.valDictMaxMin(highVal, lowVal);
                }
            }
        } else {
            if (v > maxv) {
                lowVal = maxVal;
                highVal = this.newWithDelta(maxVal, this._periodicDelta);
                possibleValuesToUse.addObject(highVal);
                return this.valDictMaxMin(highVal, lowVal);
            }
            if (v <= minv) {
                lowVal = this.newWithDelta(minVal, -this._periodicDelta);
                highVal = minVal;
                possibleValuesToUse.insertObjectAtIndex(lowVal, 0);
                return this.valDictMaxMin(highVal, lowVal);
            }
        }
        int pvcount = possibleValuesToUse.count();
        for (int i = 0; i < pvcount; ++i) {
            int nextIndex = i + 1;
            if (nextIndex == pvcount) {
                return null;
            }
            lowVal = possibleValuesToUse.objectAtIndex(i);
            highVal = possibleValuesToUse.objectAtIndex(nextIndex);
            minv = DRValueConverter.converter().doubleForValue(lowVal);
            maxv = DRValueConverter.converter().doubleForValue(highVal);
            if (v <= maxv && v > minv) break;
        }
        return this.valDictMaxMin(highVal, lowVal);
    }

    protected Object newWithDelta(Object val, double delta) {
        if (val instanceof NSTimestamp) {
            NSTimestamp vts = (NSTimestamp)val;
            NSTimestamp nvts = vts.timestampByAddingGregorianUnits(0, 0, 0, 0, 0, (int)delta);
            return nvts;
        }
        if (val instanceof Number) {
            double v = DRValueConverter.converter().doubleForValue(val) + delta;
            return new Double(v);
        }
        double v = DRValueConverter.converter().doubleForValue(val) + delta;
        return new Double(v).toString();
    }

    public Object valueForRecord(DRRecord rec) {
        Object aval = null;
        if (this._useMethod) {
            try {
                aval = this._selKey.invoke((Object)rec.rawRecord());
            }
            catch (IllegalAccessException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            aval = rec.rawRecord().valueForKeyPath(this._key);
        }
        return aval;
    }

    public Object lookUpValueForRecord(DRRecord rec) {
        Object aval = this.valueForRecord(rec);
        if (this.mustSearchForLookup()) {
            aval = this.valDictFromSearchForLookup(aval);
        } else if (this.isPreset()) {
            aval = this._presetLookupDict.objectForKey(aval);
        }
        return aval;
    }

    public String lookUpKeyForValue(Object aVal) {
        String s;
        if (this._useTimeFormat) {
            NSTimestamp ts = DRValueConverter.converter().timestampForValue(aVal);
            Format formatter = DRCriteria.formatterForFormat(this._format);
            try {
                s = formatter.format(ts);
            }
            catch (Exception ex) {
                log.warn((Object)("Error lookup " + ex + ", value=" + aVal + ": " + this));
                s = aVal.toString();
            }
        } else {
            s = aVal.toString();
        }
        return s;
    }

    public NSArray possibleUseTypes() {
        return _possibleUseTypes;
    }

    public String keyDesc() {
        if (this._keyDesc == null) {
            this._keyDesc = super.toString();
        }
        return this._keyDesc;
    }

    public String toString() {
        return "<DRSubMasterCriteria key: \"" + this.key() + "\"; label: \"" + this.label() + "\"; >";
    }
}

