/*
 * Decompiled with CFR 0.152.
 */
package er.grouping;

import com.webobjects.foundation.NSArray;
import er.grouping.DRAttribute;
import er.grouping.DRRecord;
import er.grouping.DRValueConverter;

public class DRValue {
    protected DRRecord _record;
    protected DRAttribute _attribute;
    protected boolean _isGroup = false;
    protected boolean _isTotal = false;
    protected boolean _isNull = false;
    protected Number _totalValue;
    protected double _rawTotal;
    protected String _key;

    public static DRValue nullTotal() {
        DRValue aVal = new DRValue();
        aVal.initAsNull();
        return aVal;
    }

    public static DRValue withTotalAttribute(double tot, DRAttribute att) {
        DRValue aVal = new DRValue(tot, att);
        return aVal;
    }

    public static DRValue withRecordAttribute(DRRecord rec, DRAttribute att) {
        DRValue aVal = new DRValue(rec, att);
        return aVal;
    }

    public DRValue(DRRecord rec, DRAttribute att) {
        this._record = rec;
        this._attribute = att;
    }

    public DRValue(double tot, DRAttribute att) {
        this._isTotal = true;
        this._totalValue = new Double(tot);
        this._attribute = att;
        this._rawTotal = tot;
    }

    public DRValue initAsNull() {
        this._isNull = true;
        this._totalValue = new Double(0.0);
        this._rawTotal = 0.0;
        return this;
    }

    public DRValue() {
    }

    public boolean isGroup() {
        return this._isGroup;
    }

    public boolean isTotal() {
        return this._isTotal;
    }

    public boolean isNull() {
        return this._isNull;
    }

    public boolean shouldTotal() {
        if (this._isNull) {
            return false;
        }
        if (this._isTotal) {
            return true;
        }
        return this._attribute.shouldTotal();
    }

    public String key() {
        if (this._key == null) {
            String s;
            this._key = this._isTotal ? (s = this._attribute.keyPath()) : this._attribute.keyPath();
        }
        return this._key;
    }

    public DRAttribute attribute() {
        return this._attribute;
    }

    public DRRecord record() {
        return this._record;
    }

    public Object val() {
        if (this._isTotal) {
            return this._totalValue;
        }
        if (this._record == null || this._record.rawRecord() == null) {
            return null;
        }
        if (this._attribute.isComputed()) {
            return null;
        }
        return this._record.rawRecord().valueForKeyPath(this._attribute.keyPath());
    }

    public double total() {
        if (this._isTotal) {
            return this._rawTotal;
        }
        if (this._isNull) {
            return 0.0;
        }
        if (!this._attribute.shouldTotal()) {
            return 0.0;
        }
        Object val = this.val();
        if (val != null) {
            return DRValueConverter.converter().doubleForValue(val);
        }
        return 0.0;
    }

    public void setTotal(double tot) {
        if (this._isTotal) {
            this._totalValue = new Double(tot);
            this._rawTotal = tot;
        }
    }

    public NSArray flatValues() {
        return null;
    }
}

