// Generated by the WebObjects Wizard
package er.reporting.examples;

import org.apache.log4j.Logger;

import com.webobjects.appserver.WOApplication;
import com.webobjects.eoaccess.EODatabaseDataSource;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;

import er.extensions.appserver.ERXSession;
import er.grouping.DRAttribute;
import er.grouping.DRAttributeGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRReportModel;
import er.grouping.DRSubMasterCriteria;

public class Session extends ERXSession {
    private static Logger log = Logger.getLogger(Session.class);

    protected String selectedGroupingCriteriaString;
    protected DRReportModel reportModel; // report model for EOs
    protected DRReportModel reportModel2; // report model for raw row objects

    protected NSMutableArray attribArray; // for grouping of fetched EOs in memory
    protected NSMutableArray critArray; // for grouping of fetched EOs in memory
    protected NSArray attribArray2; // for grouping of returned raw rows from GROUP BY SQL
    protected NSArray critArray2; // for grouping of returned raw rows from GROUP BY SQL
    protected NSArray attribArray3; // for docs on using WRReportEditor
    protected NSArray critArray3; // 

    protected NSArray groupByRows; // raw rows fetched using GROUP BY SQL
    public NSArray objects; // EOs fetched with a fetch spec

    public Session(){
        super();
        getReportModelDefinitionFromString();
        creatingModelsProgrammatically();
        getObjects ();
        selectedGroupingCriteriaString = "category";
    }
    public void getReportModelDefinitionFromString(){
        String st = (String)WOApplication.application().valueForKey("modelDictString");
        NSDictionary m = DRReportModel.modelFromPlistString (st);
        critArray2 = (NSArray)m.objectForKey("GroupDef");
        attribArray2 = (NSArray)m.objectForKey("AttributeDef");
        log.debug("critArray2: "+ critArray2);
        
        st = (String)WOApplication.application().valueForKey("modelDictString2");
        m = DRReportModel.modelFromPlistString (st);
        critArray3 = (NSArray)m.objectForKey("GroupDef");
        attribArray3 = (NSArray)m.objectForKey("AttributeDef");
        log.debug("critArray3: "+ critArray3);
    }
    public void getObjects(){
        EODatabaseDataSource ds = new EODatabaseDataSource(defaultEditingContext(),"Movie");
        EOFetchSpecification fs = ds.fetchSpecification();
        fs.setPrefetchingRelationshipKeyPaths(new NSArray("studio"));
        objects = ds.fetchObjects();
        log.debug("getRawRows: objects: "+ objects.count());
    }
    public void getRawRows(){
        groupByRows = EOUtilities.rawRowsForSQL(
		defaultEditingContext(), 
		"Movies", 
		"select category as category, count(*) as cnt from MOVIE group by category"); 
        log.debug("getRawRows: groupByRows: "+ groupByRows);
    }

    public DRReportModel reportModel() {
        return reportModel;
    }
    public NSArray objects() {
        return objects;
    }
    
    
    
    
    
    
    
    public void creatingModelsProgrammatically() {
        DRAttribute attGrp;
        NSMutableArray subAttList = new NSMutableArray();
        NSMutableArray smcList = new NSMutableArray();
        NSMutableArray smcList2 = new NSMutableArray();
        NSMutableArray smcList3 = new NSMutableArray();
        
        critArray = new NSMutableArray();
        attribArray = new NSMutableArray();
        attribArray.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue", true, null));
        attribArray.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("title", null, "Title", false, null));
        attribArray.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("dateReleased", null, "Date Released", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name1", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue2", true, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue3", true, null));
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AGroupofAttributes", null, "A Group of Attributes", true, subAttList, null);
        attribArray.addObject(attGrp);
        subAttList = new NSMutableArray();
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name2", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("title", null, "Revenue3", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue4", true, null));
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AnInnerGroup", null, "An Inner Group", true, subAttList, null);
        subAttList = new NSMutableArray();
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name3", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue2", true, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue3", true, null));
        subAttList.addObject(attGrp);
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AnotherGroup", null, "Another Group", true, subAttList, null);
        attribArray.addObject(attGrp);
        //format:@"%Y"
        //possibleValuesUseType:_nil
        //possibleValues:_nil
        //possibleValues:[NSArray arrayWithObjects:@"1971", @"1976", _nil]
        smcList2.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("dateReleased", false, false, null, "useRange", true, new NSArray(new Object[]{new NSTimestamp().timestampByAddingGregorianUnits(-25, 0, 0, 0, 0, 0) , new NSTimestamp().timestampByAddingGregorianUnits(-11, 0, 0, 0, 0, 0)})));
        //possibleValuesUseType:_nil
        //possibleValues:_nil
        smcList.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("category", false, false, null, "usePredefined", false, new NSArray(new Object[]{"Action" , "Drama" , "Cult"})));
        //possibleValuesUseType:@"usePeriodic"
        smcList3.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("revenue", false, false, null, "useRange", true, new NSArray(new Object[]{(new Double(500.0)) , (new Double(500000.0)) , (new Double(10000000.0)) , (new Double(14400000.0))})));
        critArray.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList, null));
        critArray.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList2, null));
        critArray.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList3, null));
        
        String s = DRReportModel.pListStringAttributeListMasterCriteriaList(attribArray, critArray);
        
        DRReportModel.writeStringToDiskPathAtomically(s, "/tmp/testmodel.plist", true);
        log.debug("");
        log.debug("");
        log.debug("As String:"+s);
        /*
        log.debug("");
        log.debug("");
        log.debug("About to get model from this string");

        NSDictionary m = DRReportModel.modelFromPlistString (s);
        log.debug("m:"+m);

        log.debug("");
        log.debug("");
        log.debug("About to turn this model back into a string");
        String sagain = DRReportModel.pListStringAttributeListMasterCriteriaList(attribArray, critArray);
        log.debug("As String: sagain:"+sagain);
        log.debug("");
        log.debug("");
        */

    }
	public DRReportModel getReportModel() {
		return reportModel;
	}
	public void setReportModel(DRReportModel reportModel) {
		this.reportModel = reportModel;
	}
	public DRReportModel getReportModel2() {
		return reportModel2;
	}
	public void setReportModel2(DRReportModel reportModel2) {
		this.reportModel2 = reportModel2;
	}
	public NSMutableArray getAttribArray() {
		return attribArray;
	}
	public void setAttribArray(NSMutableArray attribArray) {
		this.attribArray = attribArray;
	}
	public NSMutableArray getCritArray() {
		return critArray;
	}
	public void setCritArray(NSMutableArray critArray) {
		this.critArray = critArray;
	}
	public NSArray getAttribArray2() {
		return attribArray2;
	}
	public void setAttribArray2(NSArray attribArray2) {
		this.attribArray2 = attribArray2;
	}
	public NSArray getCritArray2() {
		return critArray2;
	}
	public void setCritArray2(NSArray critArray2) {
		this.critArray2 = critArray2;
	}
	public NSArray getAttribArray3() {
		return attribArray3;
	}
	public void setAttribArray3(NSArray attribArray3) {
		this.attribArray3 = attribArray3;
	}
	public NSArray getCritArray3() {
		return critArray3;
	}
	public void setCritArray3(NSArray critArray3) {
		this.critArray3 = critArray3;
	}
	public String getSelectedGroupingCriteriaString() {
		return selectedGroupingCriteriaString;
	}
	public void setSelectedGroupingCriteriaString(
			String selectedGroupingCriteriaString) {
		this.selectedGroupingCriteriaString = selectedGroupingCriteriaString;
	}


}
