package er.reporting.examples;

import org.apache.log4j.Logger;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODisplayGroup;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;

import er.grouping.DRAttribute;
import er.grouping.DRAttributeGroup;
import er.grouping.DRMasterCriteria;
import er.grouping.DRReportModel;
import er.grouping.DRSubMasterCriteria;

// Generated by the WebObjects Wizard Sat Oct 31 10:12:01 US/Central 1998
public class Main extends WOComponent  {
    private Logger log = Logger.getLogger(Main.class);

    public WODisplayGroup movieDisplayGroup;
    public NSArray attribArray;
    public NSArray critArray;

    // Generated by the WebObjects Wizard Sat Oct 31 10:12:01 US/Central 1998

    public Main(WOContext c) {
        super(c);

        String path = NSBundle.mainBundle().pathForResource("TestReportModel", "dat");
        String string = _NSStringUtilities.stringFromFile(path);
        if(string != null) {
            NSDictionary m = DRReportModel.modelDictWithPListString(string);
            critArray = (NSArray)m.objectForKey("GroupDef");
            attribArray = (NSArray)m.objectForKey("AttributeDef");
            log.debug( "critArray:"+critArray);
            log.debug( "attribArray:"+attribArray);
        }
        //creatingModelsProgrammatically();

        Session s = (Session)session();
        s.critArray = critArray;
        s.attribArray = attribArray;
    }

    public WOComponent reload() {
        ((Session)this.session()).model().setAttributeList(attribArray);
        ((Session)this.session()).model().setCriteriaList(critArray);
        
        return this;
    }

    public WOComponent rebuild() {
        //RefreshPage0 pg = (RefreshPage0) this.pageWithName("RefreshPage0");
        //pg.critArray = critArray;
        //pg.attribArray = attribArray;
        //pg.records = movieDisplayGroup.allObjects();

        Session s = (Session)session();
        s.setObjectForKey(this, "Main");
        
        DRReportModel model = DRReportModel.withRawRecordsCriteriaListAttributeList(movieDisplayGroup.allObjects(), s.critArray, s.attribArray);
        s.setModel(model);
        //model.addToZList((DRGroup)model.vList().lastObject());
        WOComponent resultPage = (WOComponent)this.pageWithName("Report");
        return resultPage;

        //return pg;
    }

    public void creatingModelsProgrammatically() {
        DRAttribute attGrp;
        NSMutableArray subAttList = new NSMutableArray();
        NSMutableArray smcList = new NSMutableArray();
        NSMutableArray smcList2 = new NSMutableArray();
        NSMutableArray smcList3 = new NSMutableArray();
        
        NSMutableArray critArray2 = new NSMutableArray();
        NSMutableArray attribArray2 = new NSMutableArray();
        attribArray2.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue", true, null));
        attribArray2.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("title", null, "Title", false, null));
        attribArray2.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("dateReleased", null, "Date Released", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name1", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue2", true, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue3", true, null));
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AGroupofAttributes", null, "A Group of Attributes", true, subAttList, null);
        attribArray2.addObject(attGrp);
        subAttList = new NSMutableArray();
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name2", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("title", null, "Revenue3", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue4", true, null));
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AnInnerGroup", null, "An Inner Group", true, subAttList, null);
        subAttList = new NSMutableArray();
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("studio.name", null, "Studio Name3", false, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue2", true, null));
        subAttList.addObject(DRAttribute.withKeyPathFormatLabelTotalUserInfo("revenue", null, "Revenue3", true, null));
        subAttList.addObject(attGrp);
        attGrp = DRAttributeGroup.withKeyPathFormatLabelTotalListUserInfo("AnotherGroup", null, "Another Group", true, subAttList, null);
        attribArray2.addObject(attGrp);
        smcList2.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("dateReleased", false, false, null, "useRange", true, new NSArray(new Object[]{new NSTimestamp().timestampByAddingGregorianUnits(-25, 0, 0, 0, 0, 0) , new NSTimestamp().timestampByAddingGregorianUnits(-11, 0, 0, 0, 0, 0)})));
        smcList.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("category", false, false, null, "usePredefined", false, new NSArray(new Object[]{"Action" , "Drama" , "Cult"})));
        smcList3.addObject(DRSubMasterCriteria.withKeyUseMethodUseTimeFormatFormatPossibleValuesUseTypeGroupEdgesPossibleValues("revenue", false, false, null, "useRange", true, new NSArray(new Object[]{(new Double(500.0)) , (new Double(500000.0)) , (new Double(10000000.0)) , (new Double(14400000.0))})));
        critArray2.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList, null));
        critArray2.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList2, null));
        critArray2.addObject(DRMasterCriteria.withSubMasterCriteriaUserInfo(smcList3, null));
        
        //String s = DRReportModel.pListStringAttributeListMasterCriteriaList(attribArray, critArray);
        
        //try{
        //    OWFileUtilities.writeStringToPath(s, "/tmp/testmodel.plist");
        //}catch(java.io.IOException e){
        //
        //}
        //log.debug( "");
        //log.debug( "");
        //log.debug( "As String:"+s);
        
        critArray = critArray2;
        attribArray = attribArray2;
        log.debug( "critArray:"+critArray);
        log.debug( "attribArray:"+attribArray);


    }

}